-- Add affiliate programs table
CREATE TABLE IF NOT EXISTS `affiliate_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_name` varchar(100) NOT NULL,
  `api_key` varchar(255) DEFAULT NULL,
  `api_secret` varchar(255) DEFAULT NULL,
  `api_url` varchar(500) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `program_name` (`program_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default affiliate programs
INSERT INTO `affiliate_programs` (`program_name`, `api_url`, `status`) VALUES
('Cuelinks', 'https://api.cuelinks.com', 1),
('INR Deals', 'https://api.inrdeals.com', 1),
('Admitad', 'https://api.admitad.com', 1),
('Commission Junction (CJ)', 'https://api.cj.com', 1);

-- Add affiliate links table to track generated links
CREATE TABLE IF NOT EXISTS `affiliate_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) NOT NULL,
  `program_name` varchar(100) NOT NULL,
  `original_url` varchar(500) NOT NULL,
  `affiliate_url` varchar(500) NOT NULL,
  `clicks` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `program_name` (`program_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

