<?php

function couponscms_store_item( $item = object, $owner_view = false ) {

    $item->is_owner_view = $owner_view;

    // Start with any hooks outside the card
    $markup  = do_action( 'before_store_outside', $item );

    // Open card and logo block
    $markup .= "\n    <div class=\"item store-card\">\n        " . do_action( 'before_store_inside', $item ) . "\n        <div class=\"image store-card-logo\">\n            <img src=\"" . store_avatar( $item->image ) . "\" alt=\"" . ts( $item->name ) . "\" loading=\"lazy\" decoding=\"async\" />\n        </div>\n        <div class=\"bottom clearfix store-card-bottom\">\n            <div class=\"title store-card-name\">\n                <a href=\"" . $item->link . "\">" . ts( $item->name ) . "</a>\n            </div>";

    // Notification Bell - below store name
    if ( !$owner_view ) {
        $markup .= '<div class="store-card-actions">';

        if ( $GLOBALS['me'] ) {
            $is_following = is_store_followed( $item->ID );
            $markup .= '<a href="#" class="store-notification-bell' . ( $is_following ? ' followed' : '' ) . '" data-store-id="' . $item->ID . '" data-ajax-call="' . ajax_call_url( 'follow_store' ) . '" data-data=\'' . json_encode( array( 'store_id' => $item->ID ) ) . '\' data-followed="' . ( $is_following ? '1' : '0' ) . '" title="' . ( $is_following ? t( 'theme_unfollow_store', 'Click to stop notifications' ) : t( 'theme_follow_store', 'Click to get notified about new coupons & products' ) ) . '">
                <i class="fas fa-bell' . ( $is_following ? '' : '-slash' ) . '"></i>
            </a>';
        } else {
            // Show login prompt for non-logged users - preserve current URL
            $current_url = urlencode( ( isset( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http' ) . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'] );
            $login_url = tlink( 'login' ) . ( strpos( tlink( 'login' ), '?' ) !== false ? '&' : '?' ) . 'redirect=' . $current_url;
            $markup .= '<a href="' . $login_url . '" class="store-notification-bell" title="' . t( 'theme_login_to_follow', 'Login to get notifications' ) . '">
                <i class="fas fa-bell-slash"></i>
            </a>';
        }

        $markup .= '</div>';
    }

    // Meta (currently hidden in CSS for clean look, but keep markup)
    $markup .= '<div class="store-card-meta">';

    if ( isset( $item->coupons ) && $item->coupons > 0 ) {
        $markup .= '<span class="store-coupons-count">' . sprintf( t( 'theme_store_coupons_count', '%s coupons' ), (int) $item->coupons ) . '</span>';
    }

    if ( ( $rating = couponscms_rating( (int) $item->stars, $item->reviews ) ) ) {
        $markup .= '<a href="' . $item->reviews_link . '#reviews" class="rating">' . $rating . '</a>';
    }

    if ( $owner_view ) {
        $markup .= '<a href="' . get_update( array( 'action' => 'edit-store', 'id' => $item->ID ) ) . '" class="button owner-button">' . t( 'edit', 'Edit' ) . '</a>';
    }

    $markup .= '</div>'; // .store-card-meta

    // Store Info (coupon count only; category removed)
    if ( isset( $item->coupons ) && $item->coupons > 0 ) {
        $coupon_text = (int) $item->coupons . ' ' . ( (int) $item->coupons == 1 ? t( 'coupon', 'Coupon' ) : t( 'coupons', 'Coupons' ) );
        $markup .= '<div class="store-card-info"><span class="store-coupon-count-text">' . $coupon_text . '</span></div>';
    }

    // Close card
    $markup .= "\n        </div>\n    " . do_action( 'after_store_inside', $item ) . "\n    </div>";

    $markup .= do_action( 'after_store_outside', $item );

    return $markup;

}
