<?php
/**
 * Slick Mega Menu Edit Walker
 *
 * @package Slick
 * @since 1.0.0
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Slick Mega Menu Edit Walker
 */
class Slick_Mega_Menu_Edit_Walker extends Walker_Nav_Menu_Edit {
    
    /**
     * Start the element output.
     */
    public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
        $item_output = '';
        
        // Call the parent method to generate the default fields
        parent::start_el( $item_output, $item, $depth, $args, $id );
        
        // Add our custom fields
        $fields = $this->get_custom_fields( $item, $depth, $args, $id );
        
        // Insert our custom fields after the menu item title field
        $position = strpos( $item_output, 'field-move' );
        
        if ( $position !== false ) {
            $item_output = substr_replace( $item_output, $fields, $position, 0 );
        }
        
        $output .= $item_output;
    }
    
    /**
     * Get custom fields HTML.
     */
    protected function get_custom_fields( $item, $depth, $args = array(), $id = 0 ) {
        ob_start();
        
        // Get the menu item meta
        $mega_menu = get_post_meta( $item->ID, '_menu_item_mega_menu', true );
        $mega_menu_columns = get_post_meta( $item->ID, '_menu_item_mega_menu_columns', true );
        $mega_menu_style = get_post_meta( $item->ID, '_menu_item_mega_menu_style', true );
        
        // Set default values
        $mega_menu = $mega_menu ? $mega_menu : '0';
        $mega_menu_columns = $mega_menu_columns ? $mega_menu_columns : '4';
        $mega_menu_style = $mega_menu_style ? $mega_menu_style : 'style1';
        
        // Only show mega menu options for top-level menu items
        if ( $depth === 0 ) {
            ?>
            <div class="field-mega-menu description description-wide">
                <h4><?php _e( 'Mega Menu Settings', 'slick' ); ?></h4>
                
                <p class="field-mega-menu-enable description">
                    <label for="edit-menu-item-mega-menu-<?php echo $item->ID; ?>">
                        <input type="checkbox" id="edit-menu-item-mega-menu-<?php echo $item->ID; ?>" 
                               class="widefat code edit-menu-item-mega-menu" 
                               name="menu-item-mega-menu[<?php echo $item->ID; ?>]" 
                               value="1" <?php checked( $mega_menu, '1' ); ?> />
                        <?php _e( 'Enable Mega Menu', 'slick' ); ?>
                    </label>
                    <span class="description"><?php _e( 'Convert this menu item into a mega menu.', 'slick' ); ?></span>
                </p>
                
                <div class="mega-menu-options" style="display: <?php echo $mega_menu === '1' ? 'block' : 'none'; ?>; margin-top: 10px; padding-top: 10px; border-top: 1px solid #eee;">
                    <p class="field-mega-menu-style description">
                        <label for="edit-menu-item-mega-menu-style-<?php echo $item->ID; ?>">
                            <?php _e( 'Mega Menu Style', 'slick' ); ?><br />
                            <select id="edit-menu-item-mega-menu-style-<?php echo $item->ID; ?>" 
                                    class="widefat code edit-menu-item-mega-menu-style" 
                                    name="menu-item-mega-menu-style[<?php echo $item->ID; ?>]">
                                <option value="style1" <?php selected( $mega_menu_style, 'style1' ); ?>><?php _e( 'Style 1 - Horizontal Layout', 'slick' ); ?></option>
                                <option value="style2" <?php selected( $mega_menu_style, 'style2' ); ?>><?php _e( 'Style 2 - Grid Layout', 'slick' ); ?></option>
                                <option value="style3" <?php selected( $mega_menu_style, 'style3' ); ?>><?php _e( 'Style 3 - Sidebar Layout', 'slick' ); ?></option>
                            </select>
                        </label>
                    </p>
                    
                    <p class="field-mega-menu-columns description">
                        <label for="edit-menu-item-mega-menu-columns-<?php echo $item->ID; ?>">
                            <?php _e( 'Number of Columns', 'slick' ); ?><br />
                            <select id="edit-menu-item-mega-menu-columns-<?php echo $item->ID; ?>" 
                                    class="widefat code edit-menu-item-mega-menu-columns" 
                                    name="menu-item-mega-menu-columns[<?php echo $item->ID; ?>]">
                                <option value="2" <?php selected( $mega_menu_columns, '2' ); ?>>2 <?php _e( 'Columns', 'slick' ); ?></option>
                                <option value="3" <?php selected( $mega_menu_columns, '3' ); ?>>3 <?php _e( 'Columns', 'slick' ); ?></option>
                                <option value="4" <?php selected( $mega_menu_columns, '4' ); ?>>4 <?php _e( 'Columns', 'slick' ); ?></option>
                                <option value="5" <?php selected( $mega_menu_columns, '5' ); ?>>5 <?php _e( 'Columns', 'slick' ); ?></option>
                            </select>
                        </label>
                    </p>
                    
                    <p class="field-mega-menu-description description">
                        <span class="description"><?php _e( 'Add featured images and descriptions to your menu items to enhance the mega menu appearance.', 'slick' ); ?></span>
                    </p>
                </div>
            </div>
            
            <script>
            jQuery(document).ready(function($) {
                // Toggle mega menu options
                $('#edit-menu-item-mega-menu-<?php echo $item->ID; ?>').on('change', function() {
                    var $options = $(this).closest('.field-mega-menu').find('.mega-menu-options');
                    
                    if ($(this).is(':checked')) {
                        $options.slideDown(200);
                    } else {
                        $options.slideUp(200);
                    }
                });
            });
            </script>
            <?php
        }
        
        return ob_get_clean();
    }
}
?>
