<?php

namespace plugin\AdmitadApiPro\inc;

/** */

class import {

    /* GET STORE INFO */

    public static function store_get_id( $id = 0 ) {

        global $db;

        $id = empty( $id ) && !empty( $_GET['id'] ) ? $_GET['id'] : $id;

        $stmt = $db->stmt_init();
        $stmt->prepare("SELECT id, adadID, category, name, image FROM " . DB_TABLE_PREFIX . "stores WHERE id = ?");
        $stmt->bind_param( "i", $id );
        $stmt->execute();
        $stmt->bind_result( $sid, $tdid, $cat, $name, $image );
        $stmt->fetch();
        $stmt->close();

        if( !empty( $sid ) ) {
            return (object) array( 'ID' => $sid, 'adadID' => $tdid, 'catID' => $cat, 'name' => esc_html( $name ), 'image' => $image );
        }

        return false;

    }

    /* CHECK IF A STORE HAS BEEN IMPORTED */

    public static function store_imported( $id = 0 ) {

        global $db;

        $id = empty( $id ) && !empty( $_GET['id'] ) ? $_GET['id'] : $id;

        $stmt = $db->stmt_init();
        $stmt->prepare("SELECT id, category, physical, name, image, sellonline FROM " . DB_TABLE_PREFIX . "stores WHERE adadID = ?");
        $stmt->bind_param( "i", $id );
        $stmt->execute();
        $stmt->bind_result( $sid, $cat, $physical, $name, $image, $sellonline );
        $stmt->fetch();
        $stmt->close();

        if( !empty( $sid ) ) {
            return (object) array( 'ID' => $sid, 'catID' => $cat, 'name' => esc_html( $name ), 'image' => $image, 'sellonline' => (boolean) ( !$physical ? 1 : $sellonline ), 'is_physical' => (boolean) $physical );
        }

        return false;

    }

    /* CHECK IF A COUPON HAS BEEN IMPORTED */

    public static function coupon_imported( $id = 0 ) {

        global $db;

        $id = empty( $id ) && !empty( $_GET['id'] ) ? $_GET['id'] : $id;

        $stmt = $db->stmt_init();
        $stmt->prepare("SELECT id, title FROM " . DB_TABLE_PREFIX . "coupons WHERE adadID = ?");
        $stmt->bind_param( "s", $id );
        $stmt->execute();
        $stmt->bind_result( $pid, $title );
        $stmt->fetch();
        $stmt->close();

        if( !empty( $pid ) ) {
            return (object) array( 'ID' => $pid, 'title' => esc_html( $title ) );
        }

        return false;

    }

    /* CHECK IF A PRODUCT HAS BEEN IMPORTED */

    public static function product_imported( $id = 0 ) {

        global $db;

        $id = empty( $id ) && !empty( $_GET['id'] ) ? $_GET['id'] : $id;

        $stmt = $db->stmt_init();
        $stmt->prepare("SELECT id, title FROM " . DB_TABLE_PREFIX . "products WHERE adadID = ?");
        $stmt->bind_param( "s", $id );
        $stmt->execute();
        $stmt->bind_result( $pid, $title );
        $stmt->fetch();
        $stmt->close();

        if( !empty( $pid ) ) {
            return (object) array( 'ID' => $pid, 'title' => esc_html( $title ) );
        }

        return false;

    }

}