<?php

function couponscms_store_item( $item = object, $owner_view = false ) {

    $item->is_owner_view = $owner_view;

    // Start with any hooks outside the card
    $markup  = do_action( 'before_store_outside', $item );

    // Open card and logo block
    $markup .= '
    <div class="item store-card">
        ' . do_action( 'before_store_inside', $item ) . '
        <div class="image store-card-logo">
            <img src="' . store_avatar( $item->image ) . '" alt="' . ts( $item->name ) . '" />
        </div>
        <div class="bottom clearfix store-card-bottom">
            <div class="title store-card-name">
                <a href="' . $item->link . '">' . ts( $item->name ) . '</a>
            </div>';

    // Meta (currently hidden in CSS for clean look, but keep markup)
    $markup .= '<div class="store-card-meta">';

    if ( isset( $item->coupons ) && $item->coupons > 0 ) {
        $markup .= '<span class="store-coupons-count">' . sprintf( t( 'theme_store_coupons_count', '%s coupons' ), (int) $item->coupons ) . '</span>';
    }
    
    // Coupon count badge for hover display
    if ( isset( $item->coupons ) && $item->coupons > 0 ) {
        $markup .= '<div class="store-card-coupon-badge">' . (int) $item->coupons . ' ' . ( (int) $item->coupons == 1 ? t( 'coupon', 'Coupon' ) : t( 'coupons', 'Coupons' ) ) . '</div>';
    }

    if ( ( $rating = couponscms_rating( (int) $item->stars, $item->reviews ) ) ) {
        $markup .= '<a href="' . $item->reviews_link . '#reviews" class="rating">' . $rating . '</a>';
    }

    if ( $owner_view ) {
        $markup .= '<a href="' . get_update( array( 'action' => 'edit-store', 'id' => $item->ID ) ) . '" class="button owner-button">' . t( 'edit', 'Edit' ) . '</a>';
    }

    $markup .= '</div>'; // .store-card-meta
    
    // Store Notification Bell - Positioned absolutely on store card
    if ( !$owner_view ) {
        if ( $GLOBALS['me'] ) {
            $is_following = is_store_followed( $item->ID );
            $markup .= '<a href="#" class="store-notification-bell" data-store-id="' . $item->ID . '" data-ajax-call="' . ajax_call_url( 'follow_store' ) . '" data-data=\'' . json_encode( array( 'store_id' => $item->ID ) ) . '\' data-followed="' . ( $is_following ? '1' : '0' ) . '" title="' . ( $is_following ? t( 'theme_unfollow_store', 'Click to stop notifications' ) : t( 'theme_follow_store', 'Click to get notified about new coupons & products' ) ) . '">
                <i class="fas fa-bell' . ( $is_following ? '' : '-slash' ) . '"></i>
            </a>';
        } else {
            // Show login prompt for non-logged users
            $markup .= '<a href="' . tlink( 'login' ) . '" class="store-notification-bell" title="' . t( 'theme_login_to_follow', 'Login to get notifications' ) . '">
                <i class="fas fa-bell-slash"></i>
            </a>';
        }
    }

    // Close card
    $markup .= '
        </div>
    ' . do_action( 'after_store_inside', $item ) . '
    </div>';

    $markup .= do_action( 'after_store_outside', $item );

    return $markup;

}
