(function() {
    "use strict";
    
    // Wait for jQuery to be available
    function initFunctions() {
        if (typeof jQuery === 'undefined') {
            setTimeout(initFunctions, 50);
            return;
        }
        
        var $ = jQuery;
        
    $( window ).on( "load", function(){

    // Dedicated home hero slider with animations, swipe, and enhanced controls
    $( '.owl-carousel.home-hero-owl' ).owlCarousel({
        items: 1,
        loop: true,
        margin: 0,
        nav: true,
        dots: true,
        autoplay: true,
        autoplayTimeout: 5000,
        autoplayHoverPause: true,
        smartSpeed: 800,
        navSpeed: 800,
        dotsSpeed: 800,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        navText: ['<i class="fas fa-chevron-left"></i>', '<i class="fas fa-chevron-right"></i>'],
        touchDrag: true,
        mouseDrag: true,
        pullDrag: true,
        freeDrag: false,
        swipe: true,
        responsive: {
            0: {
                items: 1,
                nav: true,
                dots: true,
                touchDrag: true,
                mouseDrag: true
            },
            768: {
                items: 1,
                nav: true,
                dots: true,
                touchDrag: true,
                mouseDrag: true
            },
            1024: {
                items: 1,
                nav: true,
                dots: true,
                touchDrag: true,
                mouseDrag: true
            }
        },
        onInitialized: function() {
            // Add fade animation class
            $(this.$element).closest('.home-hero-slider').addClass('slider-initialized');
        },
        onChanged: function(event) {
            // Add animation on slide change
            $(this.$element).find('.owl-item').removeClass('slide-active');
            $(this.$element).find('.owl-item.active').addClass('slide-active');
        }
    });

    // Generic carousels except hero slider and category list3
    $( '.owl-carousel' ).not( '.home-hero-owl' ).not( '.list3' ).not('.list' ).owlCarousel({ loop: true, margin: 10, nav: false,
        responsive: {
            0: {
                items:1
            },
            600: {
                items:1
            },
            1000: {
                items:1
            }
        }
    });

    $( '.owl-carousel.list3' ).owlCarousel({ loop: false, margin: 10, nav: true, navText: ['<i class="fas fa-angle-left"></i>', '<i class="fas fa-angle-right"></i>'], dots: false,
        responsive: {
            0: {
                items:2,
                nav:false
            },
            600: {
                items:2
            },
            1000: {
                items:5
            }
        }
    });

    $(window).resize( function(){
        if( $('.list4 > .item').length > 0 ) {
            $('.list4 > .item .title').addClass('sized');
            $('.list4 > .item h4, .list4 > .item .description > p').width(200);
            setTimeout(function(){
                var width = $('.list4 > .item .content').width();
                $('.list4 > .item h4, .list4 > .item .description > p').width(width);
            }, 200);
        }
    }).resize();

    $(document).on( 'mouseover', '.title.sized', function(){
        if( $(this).find('.dtitle').length == 0 ) {
            $(this).append('<div class="dtitle"><h4>' + $(this).text() + '</h4></div>');
            $(this).find('.dtitle').fadeIn(200);
        }
    });

    $(document).on( 'mouseleave', '.title.sized', function(){
        $(this).find('.dtitle').fadeOut(200, function(){
            $(this).remove();
        });
    });

    $( '[data-countdown]' ).each(function(){
        var t = $(this);
        var countDownDate = new Date(t.data('countdown')).getTime();
        var x = setInterval(function() {
            var now = new Date().getTime();
            var distance = countDownDate - now;
            var days    = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours   = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            var content = '';

            if( days > 0 ) {
                content += days + '<span>d</span> ';
            }

            if( hours > 0 ) {
                content += hours + '<span>h</span> ';
            }

            if( minutes > 0 ) {
                content += minutes + '<span>m</span> ';
            }

            content += seconds + '<span>s</span> ';

            t.html(content);

            if (distance < 0) {
                clearInterval(x);
                t.html('');
            }
        }, 1000);
    });

    $( '.show-search' ).on( 'click', function(e){
        e.preventDefault();
        var container = $('.menu-container');
        if( !container.hasClass('active') ) {
            container.addClass('active');
        }
        container.find('.mobile-menu').animate( { left: '-100%' }, 100 );
    });

    $( '.close-search' ).on( 'click', function(e){
        e.preventDefault();
        $('.menu-container.active .mobile-menu').animate( { left: 0 }, 100 );
    });

    $( '.mobile-menu .contains-sub-menu > a' ).on( 'click', function(e) {
        e.preventDefault();
        var t = $(this);
        t.parent().toggleClass( 'active' );
        var ul = t.parent().find( ' > ul' );
        ul.toggleClass( 'visible' );
    });

    var progress_bar, progress_height, progress_top_offset;

    if( $( '.show-progress-bar' ).length > 0 ) {
        progress_bar = $( '.menu-container' ).append( '<div class="progress-bar" style="position:absolute;top:0;background:#ed174f;height:3px;width:0;"></div>' );
        progress_height = $( '.show-progress-bar' ).height();
        progress_top_offset = $( '.show-progress-bar' ).offset().top;
    }

    $( document ).scroll(function(){
        var dtt = $(document).scrollTop();
        if( dtt > 70 ) {
            $( '.menu-container' ).addClass( 'fixed' );
        } else {
            $( '.menu-container' ).removeClass( 'fixed' );
        }
        if( typeof progress_bar != 'undefined' ) {
            var percent = ( ( ( dtt - progress_top_offset ) / progress_height ) * 100 );
            if( percent < 0 ) percent = 0;
            if( percent > 100 ) percent = 100;
            $( '.progress-bar' ).width( parseInt( percent ) + '%' );
        }
    }).scroll();

    $( '.lines' ).on( 'click', function(e){
        e.preventDefault();
        $(this).parents('.menu-container').toggleClass('active');
    });

    $( '.search-input input' ).on( 'keyup', function(e){
        var t = $(this);
        var parent = t.parents('.search-input');
        var helper = parent.find( '.search-helper' );
        helper.removeClass( 'visible' );
        $.post( t.data( 'ajax-search' ), {text: t.val()}, function(data) {
            if( data.length ) {
                helper.html(data);
                helper.addClass( 'visible' );
            }    
        });
    });

    // Search dropdown removed - no longer needed

    $( '[data-code]' ).on( 'click', function(e) {
        e.preventDefault();
        var t = $(this);
        var code = t.data('code');

        // Show the code on the button/link
        t.text(code).addClass('active').removeAttr('data-code');

        // Copy code to clipboard automatically
        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(code).catch(function(){});
        } else {
            var $temp = $('<input>');
            $('body').append($temp);
            $temp.val(code).select();
            try { document.execCommand('copy'); } catch(e) {}
            $temp.remove();
        }
    });

    $( '.code-revealed.button' ).on( 'click', function(e) {
        e.preventDefault();
        var t = $(this);
        var ico = t.find('i');
        var ico_str = ico.attr('class');
        t.find( 'input' ).focus().select();
        document.execCommand( 'copy' );
        t.find( 'input' ).blur();
        ico.attr('class', 'fas fa-check');
        setTimeout(function(){
            ico.attr('class', ico_str);
        }, 2000);
    } );

    $( '.store-info-list a.hours' ).on( 'click', function( e ) {
        e.preventDefault();
        var ul = $(this).parent().next( 'ul' );
        if( ul.is( ':visible' ) ) {
            ul.fadeOut( 200 );
        } else {
            ul.fadeIn( 200 );
        }
    });

    // Coupon Modal Popup - Enhanced design like image
    function showCouponModal(couponData) {
        var storeLogo = couponData.store_logo || '';
        var storeName = couponData.store_name || '';
        var shareLink = couponData.share_link || window.location.href;
        var encodedLink = encodeURIComponent(shareLink);
        
        var modalHtml = '<div id="coupon-modal-overlay" class="coupon-modal-overlay">' +
            '<div class="coupon-modal">' +
            '<button class="coupon-modal-close">&times;</button>' +
            '<div class="coupon-modal-content">' +
            // Store Logo
            (storeLogo ? '<div class="coupon-modal-logo"><img src="' + storeLogo + '" alt="' + storeName + '" /></div>' : '') +
            // Offer Title
            '<h3 class="coupon-modal-title">' + (couponData.title || 'Coupon Code') + '</h3>' +
            // Copy instruction
            '<p class="coupon-copy-instruction">Copy and paste this code at <strong class="store-name-highlight">' + (storeName || 'the store') + '</strong></p>' +
            // Coupon Code with Copy Button
            '<div class="coupon-code-container">' +
            '<div class="coupon-code-display">' +
            '<span class="coupon-code-text">' + couponData.code + '</span>' +
            '</div>' +
            '<button class="button coupon-copy-btn" data-copy-code="' + couponData.code + '">Copy</button>' +
            '</div>' +
            // Feedback Section
            '<div class="coupon-feedback">' +
            '<span class="feedback-question">Did it work?</span>' +
            '<div class="feedback-buttons">' +
            '<button class="feedback-btn feedback-no" data-feedback="no">😞 No</button>' +
            '<button class="feedback-btn feedback-yes active" data-feedback="yes">😊 Yes</button>' +
            '</div>' +
            '</div>' +
            // Share Section
            '<div class="coupon-share-section">' +
            '<h4>Share This Coupon</h4>' +
            '<div class="coupon-share-buttons">' +
            '<a href="https://www.facebook.com/sharer/sharer.php?u=' + encodedLink + '" target="_blank" class="share-btn share-facebook" title="Share on Facebook"><i class="fab fa-facebook-f"></i></a>' +
            '<a href="https://twitter.com/intent/tweet?url=' + encodedLink + '" target="_blank" class="share-btn share-twitter" title="Share on Twitter"><i class="fab fa-twitter"></i></a>' +
            '<a href="https://www.tumblr.com/widgets/share/tool?canonicalUrl=' + encodedLink + '" target="_blank" class="share-btn share-tumblr" title="Share on Tumblr"><i class="fab fa-tumblr"></i></a>' +
            '<a href="https://pinterest.com/pin/create/button/?url=' + encodedLink + '" target="_blank" class="share-btn share-pinterest" title="Share on Pinterest"><i class="fab fa-pinterest"></i></a>' +
            '<a href="https://api.whatsapp.com/send?text=' + encodedLink + '" target="_blank" class="share-btn share-whatsapp" title="Share on WhatsApp"><i class="fab fa-whatsapp"></i></a>' +
            '<a href="https://t.me/share/url?url=' + encodedLink + '" target="_blank" class="share-btn share-telegram" title="Share on Telegram"><i class="fab fa-telegram"></i></a>' +
            '</div>' +
            '</div>' +
            // Visit Store Button
            '<div class="coupon-modal-actions">' +
            '<button class="button coupon-visit-btn" data-visit-url="' + couponData.affiliate_url + '">' +
            '<i class="fas fa-external-link-alt"></i> Visit Store' +
            '</button>' +
            '</div>' +
            '</div>' +
            '</div>' +
            '</div>';
        
        $('body').append(modalHtml);
        $('#coupon-modal-overlay').addClass('show').fadeIn(300);
        
        // Automatically open affiliate link in background when popup appears
        if( couponData.affiliate_url ) {
            // Open in new tab/window
            window.open(couponData.affiliate_url, '_blank');
        }
        
        // Close modal handlers
        $('.coupon-modal-close, .coupon-modal-overlay').on('click', function(e) {
            if( e.target === this ) {
                $('#coupon-modal-overlay').fadeOut(300, function() {
                    $(this).remove();
                });
            }
        });
        
        // Copy code handler
        $('.coupon-copy-btn').on('click', function() {
            var code = $(this).data('copy-code');
            var $temp = $('<input>');
            $('body').append($temp);
            $temp.val(code).select();
            document.execCommand('copy');
            $temp.remove();
            
            $(this).html('Copied!');
            $(this).addClass('copied');
            setTimeout(function() {
                $('.coupon-copy-btn').html('Copy').removeClass('copied');
            }, 2000);
        });
        
        // Feedback handler
        $('.feedback-btn').on('click', function() {
            var feedback = $(this).data('feedback');
            $('.feedback-btn').removeClass('active');
            $(this).addClass('active');
            // You can add AJAX call here to save feedback
        });
        
        // Visit store handler - redirect after copy
        $('.coupon-visit-btn').on('click', function() {
            var url = $(this).data('visit-url');
            window.open(url, '_blank');
            $('#coupon-modal-overlay').fadeOut(300, function() {
                $(this).remove();
            });
        });
    }

    // Handle Show Coupon button clicks specifically
    $( document ).on( 'click', '.show-coupon-popup', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $link = $(this);
        var couponId = $link.data('coupon-id');
        
        if( !couponId ) {
            // Try to extract from URL
            var revealUrl = $link.attr('href');
            var match = revealUrl ? revealUrl.match(/coupon=(\d+)/) : null;
            if( match && match[1] ) {
                couponId = match[1];
            } else {
                alert('Error: Could not find coupon ID');
                return;
            }
        }
        
        // Immediately open the target/affiliate URL in a new tab (background)
        // so the user stays on site while merchant opens separately.
        var targetUrl = $link.data('target-on-click') || $link.attr('href');
        if( targetUrl ) {
            try {
                window.open( targetUrl, '_blank' );
            } catch (err) {
                console && console.warn && console.warn('Popup blocked when opening coupon URL', err);
            }
        }
        
        // Show loading state for popup
        $link.addClass('loading').prop('disabled', true);
        
        // Get coupon code via AJAX
        var ajaxUrl = $link.data('ajax-url');
        if( !ajaxUrl ) {
            // Fallback: construct URL
            ajaxUrl = window.location.origin + window.location.pathname + '?ajax=call&type=reveal_coupon_code';
        }
        
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: {
                coupon_id: couponId
            },
            dataType: 'json',
            success: function(response) {
                $link.removeClass('loading').prop('disabled', false);
                if( response && response.success ) {
                    showCouponModal(response);
                } else {
                    alert('Error: ' + (response && response.message ? response.message : 'Could not reveal coupon code'));
                }
            },
            error: function(xhr, status, error) {
                $link.removeClass('loading').prop('disabled', false);
                console.error('AJAX Error:', status, error, xhr);
                alert('Error: Could not reveal coupon code. Please try again.');
            }
        });
    });

    $( document ).on( 'click', '[data-target-on-click]', function(e) {
        var $link = $(this);
        var revealUrl = $link.attr('href');
        var targetUrl = $link.data( 'target-on-click' );
        var couponId = $link.data( 'coupon-id' );
        var isRevealCode = $link.data( 'reveal-code' ) || ( revealUrl && revealUrl.indexOf('reveal_code') !== -1 );
        
        // Skip if already handled by show-coupon-popup handler
        if( $link.hasClass('show-coupon-popup') ) {
            return;
        }
        
        // Check if this is a reveal_code link (coupon popup)
        if( isRevealCode && couponId ) {
            e.preventDefault();
            e.stopPropagation();
            
            // Show loading state
            $link.addClass('loading').prop('disabled', true);
            
            // Get coupon code via AJAX
            var ajaxUrl = $link.data('ajax-url');
            if( !ajaxUrl ) {
                // Fallback: construct URL
                ajaxUrl = window.location.origin + window.location.pathname + '?ajax=call&type=reveal_coupon_code';
            }
            
            $.ajax({
                url: ajaxUrl,
                type: 'POST',
                data: {
                    coupon_id: couponId
                },
                dataType: 'json',
                success: function(response) {
                    $link.removeClass('loading').prop('disabled', false);
                    if( response && response.success ) {
                        showCouponModal(response);
                    } else {
                        alert('Error: ' + (response && response.message ? response.message : 'Could not reveal coupon code'));
                    }
                },
                error: function(xhr, status, error) {
                    $link.removeClass('loading').prop('disabled', false);
                    console.error('AJAX Error:', status, error);
                    alert('Error: Could not reveal coupon code. Please try again.');
                }
            });
        } else if( isRevealCode ) {
            // Fallback: extract coupon ID from URL
            e.preventDefault();
            e.stopPropagation();
            var match = revealUrl.match(/coupon=(\d+)/);
            if( match && match[1] ) {
                $link.attr('data-coupon-id', match[1]).trigger('click');
            } else {
                // Fallback to popup window
                window.open(revealUrl, '_blank');
            }
        } else {
            // Not a reveal_code link, redirect normally
            e.preventDefault();
            var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
            if( isSafari ) {
                $link.removeAttr( 'target' );
            }
            window.location = targetUrl;
        }
    });

    $( '.reward-claim.button' ).on( 'click', function(e){
        e.preventDefault();
        var t = $(this);
        t.parent().prev().slideDown();
        t.remove();
    } );

    $( document ).on( 'click', '.desc-toggle', function( e ) {
        e.preventDefault();
        var t = $(this);
        var target = $( t.data( 'desc-target' ) );
        if( target.length === 0 ) {
            return;
        }
        var openText = t.data( 'open-text' );
        var closeText = t.data( 'close-text' );
        target.toggleClass( 'collapsed' );
        if( target.hasClass( 'collapsed' ) ) {
            t.text( openText );
        } else {
            t.text( closeText );
        }
    } );

    $( 'a[href="#"]' ).on( 'click', function(e) {
        e.preventDefault();
    });

    // Cookie consent banner
    var cookieConsentKey = 'cookie_consent_accepted';
    if( !localStorage.getItem( cookieConsentKey ) ) {
        $('#cookie-consent').fadeIn(200);
    }
    $('#cookie-consent-accept').on('click', function() {
        localStorage.setItem( cookieConsentKey, '1' );
        $('#cookie-consent').fadeOut(200);
    });

    // Scroll to Top Button
    var scrollToTopBtn = $('#scroll-to-top');
    
    $(window).on('scroll', function() {
        if ($(window).scrollTop() > 300) {
            scrollToTopBtn.addClass('show');
        } else {
            scrollToTopBtn.removeClass('show');
        }
    });

    scrollToTopBtn.on('click', function(e) {
        e.preventDefault();
        // Smooth scroll to top with easing
        $('html, body').animate({
            scrollTop: 0
        }, 800, 'swing');
    });
    
    // Smooth scroll for anchor links
    $('a[href^="#"]').on('click', function(e) {
        var target = $(this.getAttribute('href'));
        if( target.length && this.getAttribute('href') !== '#' ) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: target.offset().top - 80
            }, 800, 'swing');
        }
        });

    // Coupon Countdown Timer
    function updateCountdowns() {
        $('.coupon-countdown').each(function() {
            var $countdown = $(this);
            var expiryTimestamp = parseInt($countdown.data('expiry'));
            var couponId = $countdown.find('.countdown-timer').attr('id').replace('countdown-', '');
            
            if (!expiryTimestamp) return;
            
            var now = Math.floor(Date.now() / 1000);
            var distance = expiryTimestamp - now;
            
            if (distance < 0) {
                $countdown.html('<span class="countdown-expired">' + (t('theme_expired', 'Expired') || 'Expired') + '</span>');
                return;
            }
            
            var days = Math.floor(distance / (60 * 60 * 24));
            var hours = Math.floor((distance % (60 * 60 * 24)) / (60 * 60));
            var minutes = Math.floor((distance % (60 * 60)) / 60);
            var seconds = Math.floor(distance % 60);
            
            $('#days-' + couponId).text(String(days).padStart(2, '0'));
            $('#hours-' + couponId).text(String(hours).padStart(2, '0'));
            $('#minutes-' + couponId).text(String(minutes).padStart(2, '0'));
            $('#seconds-' + couponId).text(String(seconds).padStart(2, '0'));
        });
    }
    
    // Update countdowns every second
    if ($('.coupon-countdown').length > 0) {
        updateCountdowns();
        setInterval(updateCountdowns, 1000);
    }

    // Enhanced Social Sharing - Ensure menu is clickable
    $(document).on('click', '.share-coupon-btn', function(e) {
        e.preventDefault();
        e.stopPropagation();
        // Menu is always visible, just ensure it's accessible
        var $menu = $(this).siblings('.social-share-menu');
        if ($menu.length) {
            $menu.css({
                'display': 'block',
                'opacity': '1',
                'visibility': 'visible',
                'pointer-events': 'auto'
            });
        }
    });
    
    // Ensure share links are clickable
    $(document).on('click', '.social-share-menu a', function(e) {
        // Allow default link behavior
        e.stopPropagation();
    });
    
    // Close menu when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.share-menu-container').length) {
            // Keep menu visible but ensure it doesn't interfere
        }
    });

        });
    }
    
    // Start initialization
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initFunctions);
    } else {
        initFunctions();
    }
})();