<?php

namespace plugin\AdmitadApiPro\inc;

class actions {

    /* ASSIGN ID */

    public static function assign( $opt = array() ) {

        global $db;

        $stmt = $db->stmt_init();

        // delete stores assigned
        $stmt->prepare( "UPDATE " . DB_TABLE_PREFIX . "stores SET adadID = 0 WHERE adadID = ?" );
        $stmt->bind_param( "i", $opt['adadID'] );
        $stmt->execute();

        $stmt->prepare( "UPDATE " . DB_TABLE_PREFIX . "stores SET adadID = ? WHERE id = ?" );
        $stmt->bind_param( "ii", $opt['adadID'], $opt['storeID'] );
        $execute = $stmt->execute();
        $stmt->close();

        if( $execute ) {
            return true;
        }

        return false;

    }

/* ADD STORE */

    public static function add_store( $opt = array() ) {

        global $db;

        $opt = \site\utils::array_map_recursive( 'trim', $opt );

        if( empty( $opt['name'] ) || ( $opt['type'] == 0 && empty( $opt['url'] ) ) ) {
            return false;
        }

        $stmt = $db->stmt_init();
        $stmt->prepare( "INSERT INTO " . DB_TABLE_PREFIX . "stores (adadID, user, category, popular, physical, name, link, description, tags, image, hours, phoneno, sellonline, visible, meta_title, meta_keywords, meta_desc, lastupdate_by, lastupdate, extra, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, NOW())" );

        $logo = \site\images::upload( ( !empty( $opt['import_logo'] ) && !empty( $opt['logo_url'] ) && empty( $opt['logo']['name'] ) ? $opt['logo_url'] : $opt['logo'] ), 'logo_', array( 'path' => DIR . '/', 'current' => ( !empty( $opt['logo_url'] ) ? $opt['logo_url'] : '' ) ) );
        $hours = @serialize( $opt['hours'] );
        $extra = \site\utils::array_sanitize( $opt['extra'] );
        $extra = @serialize( $extra );
        $stmt->bind_param( "iiiiisssssssiisssis", $opt['adadID'], $opt['user'], $opt['category'], $opt['popular'], $opt['type'], $opt['name'], $opt['url'], $opt['description'], $opt['tags'], $logo, $hours, $opt['phone'], $opt['sellonline'], $opt['publish'], $opt['meta_title'], $opt['meta_keywords'], $opt['meta_desc'], $GLOBALS['me']->ID, $extra );
        $execute = $stmt->execute();
        $insert_id = $stmt->insert_id;
        $stmt->close();

        if( $execute ) {
            return $insert_id;
        }

        return false;

    }

    /* ADD COUPON */

    public static function add_item( $opt = array() ) {

        global $db;

        $opt = \site\utils::array_map_recursive( 'trim', $opt );

        if( empty( $opt['name'] ) ) {
            return false;
        }

        $stmt = $db->stmt_init();
        $stmt->prepare( "INSERT INTO " . DB_TABLE_PREFIX . "coupons (adadID, user, store, category, popular, exclusive, printable, available_online, title, link, description, tags, image, code, source, visible, start, expiration, cashback, meta_title, meta_keywords, meta_desc, votes, votes_percent, verified, last_verif, lastupdate_by, lastupdate, extra, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), ?, NOW())" );

        $image = \site\images::upload( ( !empty( $opt['import_image'] ) && !empty( $opt['image_url'] ) && empty( $opt['image']['name'] ) ? $opt['image_url'] : $opt['image'] ), 'coupon_', array( 'path' => DIR . '/', 'current' => ( !empty( $opt['image_url'] ) ? $opt['image_url'] : '' ) ) );
        $source = \site\images::upload( ( is_array( $opt['source'] ) ? $opt['source'] : array() ), 'print_', array( 'path' => DIR . '/', 'current' => ( is_string( $opt['source'] ) ? $opt['source'] : '' ) ) );
        $extra = \site\utils::array_sanitize( $opt['extra'] );
        $extra = @serialize( $extra );
        $stmt->bind_param( "siiiiiiisssssssississsidisis", $opt['adadID'], $GLOBALS['me']->ID, $opt['store'], $opt['category'], $opt['popular'], $opt['exclusive'], $opt['printable'], $opt['available_online'], $opt['name'], $opt['link'], $opt['description'], $opt['tags'], $image, $opt['code'], $source, $opt['publish'], $opt['start'], $opt['end'], $opt['cashback'], $opt['meta_title'], $opt['meta_keywords'], $opt['meta_desc'], $opt['votes'], $opt['votes_average'], $opt['verified'], $opt['last_verif'], $GLOBALS['me']->ID, $extra );
        $execute = $stmt->execute();

        $insert_id = $stmt->insert_id;
        $stmt->close();

        if( $execute ) {
            return $insert_id;
        }

        return false;

    }

}