<?php

/* PUT THE OBJECT INTO GLOBAL VARIABLES */

$GLOBALS['item'] = \query\main::page_info( 0, array( 'update_views' => '' ) );
$GLOBALS['exists'] = \query\main::page_exists( 0, array( 'user_view' => '' ) );

/* CHECK IF PAGE EXISTS */

function exists() {
  return $GLOBALS['exists'];
}

/* INFORMATION ABOUT PAGE */

function the_item() {
  return $GLOBALS['item'];
}

/* GET EXTRA FIELD DATA */

function extra( $id = '' ) {
    if( empty( $id ) ) return false;
    if( isset( $GLOBALS['item']->extra[$id] ) ) {
        return $GLOBALS['item']->extra[$id];
    }
    return false;
}

/* GET THE ID */

function ID() {
    return $GLOBALS['item']->ID;
}

/* GET THE TITLE */

function title() {
    return $GLOBALS['item']->name;
}

/* GET THE CONTENT */

function content( $escape = false, $use_shortcodes = true, $allow_filters = true ) {
    $item = $GLOBALS['item'];
    $content_type = isset( $item->extra['content_type'] ) ? $item->extra['content_type'] : 'plain';
    $raw_content = $item->html;
    
    // Handle PHP content type
    if( $content_type === 'php' ) {
        // Execute PHP code within theme context
        // All theme functions and variables are available in the PHP code
        ob_start();
        try {
            // Execute PHP code - it has access to all theme functions, $GLOBALS, etc.
            // The output will be wrapped in the theme's container div automatically
            eval( '?>' . $raw_content );
            $output = ob_get_contents();
            
            // If output is empty, check for errors
            if( empty( $output ) && ob_get_level() > 0 ) {
                $output = ''; // Allow empty output (PHP might just set variables)
            }
        } catch( \ParseError $e ) {
            $output = '<div class="alert" style="padding:15px; background:#fee; border:2px solid #fcc; color:#c00; border-radius:4px; margin:20px 0;">
                <strong>PHP Parse Error:</strong> ' . htmlspecialchars( $e->getMessage() ) . '<br>
                <small>File: ' . htmlspecialchars( $e->getFile() ) . ', Line ' . $e->getLine() . '</small>
            </div>';
        } catch( \Error $e ) {
            $output = '<div class="alert" style="padding:15px; background:#fee; border:2px solid #fcc; color:#c00; border-radius:4px; margin:20px 0;">
                <strong>PHP Error:</strong> ' . htmlspecialchars( $e->getMessage() ) . '<br>
                <small>File: ' . htmlspecialchars( $e->getFile() ) . ', Line ' . $e->getLine() . '</small>
            </div>';
        } catch( \Exception $e ) {
            $output = '<div class="alert" style="padding:15px; background:#fee; border:2px solid #fcc; color:#c00; border-radius:4px; margin:20px 0;">
                <strong>PHP Exception:</strong> ' . htmlspecialchars( $e->getMessage() ) . '<br>
                <small>File: ' . htmlspecialchars( $e->getFile() ) . ', Line ' . $e->getLine() . '</small>
            </div>';
        }
        ob_end_clean();
        
        // Return output - it will be placed inside the theme's container div
        // PHP code should output HTML that uses theme CSS classes for proper styling
        return $output;
    }
    
    // Handle HTML content type
    if( $content_type === 'html' ) {
        // Don't escape HTML, but still process shortcodes and filters if needed
        $html = $raw_content;
        
        // Apply font family if set
        $font_family = isset( $item->extra['font_family'] ) ? $item->extra['font_family'] : '';
        if( !empty( $font_family ) && $font_family !== 'Poppins' ) {
            // Wrap content in div with font family style if not already wrapped
            if( strpos( $html, '<style' ) === false && strpos( $html, 'font-family' ) === false ) {
                $html = '<div style="font-family: ' . esc_html( $font_family ) . ', sans-serif;">' . $html . '</div>';
            }
        }
        
        if( $use_shortcodes ) {
            $html = \site\content::shortcodes( $html );
        }
        if( $allow_filters ) {
            $html = \site\content::filters( $html, 'page_single' );
        }
        return $html;
    }
    
    // Default: Plain text (original behavior)
    $html = nl2br( $raw_content );
    $output = \site\content::content( 'page_single', esc_html( $html ), (boolean) \query\main::get_option( 'smilies_pages' ), $use_shortcodes, false, $escape, $allow_filters );
    
    // Apply font family if set
    $font_family = isset( $item->extra['font_family'] ) ? $item->extra['font_family'] : '';
    if( !empty( $font_family ) && $font_family !== 'Poppins' ) {
        $output = '<div style="font-family: ' . esc_html( $font_family ) . ', sans-serif;">' . $output . '</div>';
    }
    
    return $output;
}

/* PERSONALIZED META TAGS ONLY IF THE PAGE EXISTS */

if( $GLOBALS['exists'] > 0 ) {

    /* METATAGS - TITLE */

    function meta_title() {

        if( !empty( $GLOBALS['item']->meta_title ) ) {
            return meta_default( '', $GLOBALS['item']->meta_title );
        } else
            return meta_default( '', \query\main::get_option( 'sitetitle' ) );

    }

    /*  METATAGS - KEYWORDS */

    function meta_keywords() {

        if( !empty( $GLOBALS['item']->meta_keywords ) ) {
          return meta_default( '', $GLOBALS['item']->meta_keywords );
        } else
          return meta_default( '', \query\main::get_option( 'meta_keywords' ) );

    }

    /*  METATAGS - DESCRIPTION */

    function meta_description() {

        if( !empty( $GLOBALS['item']->meta_description ) ) {
          return meta_default( '', $GLOBALS['item']->meta_description );
        } else
          return meta_default( '', \query\main::get_option( 'meta_description' ) );

    }

    /* IS CURRENT PAGE */

    function this_is_page( $identifier = 0 ) {

        if( !empty( $identifier ) ) {

            global $GET;

            if( isset( $GET['id'] ) && strcasecmp( $GET['id'], $identifier ) == 0 ) {   
                return true;
            }
            return false;

        }

        return true;

    }

    /* ACTION BEFORE DISPLAYING THE CONTENT */

    do_action( 'before_page_page', $GLOBALS['item'] );

} else {

    /* THIS IS 404 PAGE */

    function this_is_404_page() {

        return true;

    }

}