/**
 * Slick Mega Menu JavaScript
 */

jQuery(document).ready(function($) {
    'use strict';
    
    // Initialize mega menu
    function initMegaMenu() {
        var $megaMenuItems = $('.mega-menu');
        
        // Desktop hover effect
        $megaMenuItems.on('mouseenter', function() {
            var $this = $(this);
            var $megaMenu = $this.find('> .mega-menu-container');
            
            // Close other open mega menus
            $('.mega-menu-container').not($megaMenu).removeClass('active');
            
            // Position and show the current mega menu
            if ($megaMenu.length) {
                var windowWidth = $(window).width();
                var megaMenuWidth = $megaMenu.outerWidth();
                var offset = $this.offset();
                var menuPosition = offset.left + ($this.outerWidth() / 2) - (megaMenuWidth / 2);
                
                // Adjust position if the menu goes off-screen
                if (menuPosition < 20) {
                    menuPosition = 20;
                } else if (menuPosition + megaMenuWidth > windowWidth - 20) {
                    menuPosition = windowWidth - megaMenuWidth - 20;
                }
                
                $megaMenu.css({
                    'left': menuPosition,
                    'opacity': 1,
                    'display': 'block'
                }).addClass('active');
            }
        });
        
        // Close mega menu when mouse leaves
        $('.header-menu').on('mouseleave', function() {
            $('.mega-menu-container').removeClass('active');
        });
        
        // Mobile menu toggle
        $('.mega-menu > a').on('click', function(e) {
            if (isMobile()) {
                e.preventDefault();
                var $this = $(this);
                var $parent = $this.parent();
                var $subMenu = $this.siblings('.mega-menu-container');
                
                // Toggle active class
                $parent.toggleClass('active');
                
                // Toggle submenu
                if ($parent.hasClass('active')) {
                    $subMenu.slideDown(300);
                } else {
                    $subMenu.slideUp(300);
                }
                
                // Close other open mega menus
                $('.mega-menu').not($parent).removeClass('active').find('.mega-menu-container').slideUp(300);
            }
        });
        
        // Close menu when clicking outside
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.mega-menu').length) {
                $('.mega-menu').removeClass('active');
                $('.mega-menu-container').slideUp(300);
            }
        });
        
        // Handle window resize
        var resizeTimer;
        $(window).on('resize', function() {
            clearTimeout(resizeTimer);
            resizeTimer = setTimeout(function() {
                $('.mega-menu-container').removeClass('active');
            }, 250);
        });
    }
    
    // Check if device is mobile
    function isMobile() {
        return window.innerWidth <= 991;
    }
    
    // Initialize the mega menu
    initMegaMenu();
    
    // Reinitialize on AJAX content load (if needed)
    $(document).ajaxComplete(function() {
        initMegaMenu();
    });
    
    // Admin: Toggle mega menu options
    $('body').on('change', '.edit-menu-item-mega-menu', function() {
        var $this = $(this);
        var $options = $this.closest('.field-mega-menu').find('.mega-menu-options');
        
        if ($this.is(':checked')) {
            $options.slideDown(200);
        } else {
            $options.slideUp(200);
        }
    });
});
