<div class="bgGray">
    <div class="hero-title">
        <div class="container">
            <h2><?php te( 'theme_register_title', 'Create Account' ); ?></h2>
        </div>
    </div>
</div>

<div class="pt-75 pb-75 clearfix">
    <div class="container">
        <div class="form-box">
            <!-- Register Tabs -->
            <div class="register-tabs" style="display: flex; gap: 10px; margin-bottom: 20px; border-bottom: 2px solid #e5e5e5;">
                <button class="register-tab-btn active" data-tab="email" style="flex: 1; padding: 12px; background: none; border: none; border-bottom: 2px solid transparent; cursor: pointer; font-weight: 500; color: #666;">
                    <i class="fas fa-envelope"></i> Email Register
                </button>
                <button class="register-tab-btn" data-tab="mobile" style="flex: 1; padding: 12px; background: none; border: none; border-bottom: 2px solid transparent; cursor: pointer; font-weight: 500; color: #666;">
                    <i class="fas fa-mobile-alt"></i> Mobile OTP
                </button>
            </div>
            
            <!-- Email Register Form -->
            <div id="email-register-form">
                <?php echo register_form( tlink( 'user/account' ) ); ?>
            </div>
            
            <!-- Mobile OTP Register Form -->
            <div id="mobile-register-form" style="display: none;">
                <form id="mobile-otp-register-form" class="other_form">
                    <div id="mobile-otp-register-messages"></div>
                    <div class="form_field">
                        <label for="mobile_register_name"><?php te( 'theme_your_name', 'Your Name' ); ?>:</label>
                        <div>
                            <input type="text" id="mobile_register_name" name="name" placeholder="<?php te( 'theme_enter_name', 'Enter your name' ); ?>" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 5px; margin-bottom: 15px;" />
                            <small style="color: #666;"><?php te( 'theme_name_change_info', 'You can change your name later in account settings' ); ?></small>
                        </div>
                    </div>
                    <div class="form_field" id="phone-register-input-section">
                        <label for="mobile_register_phone"><?php te( 'theme_mobile_number', 'Mobile Number' ); ?>:</label>
                        <div>
                            <input type="tel" id="mobile_register_phone" name="phone" placeholder="+1234567890" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 5px; margin-bottom: 10px;" />
                            <button type="button" id="send-otp-register-btn" class="button" style="width: 100%;"><?php te( 'theme_send_otp', 'Send OTP' ); ?></button>
                        </div>
                    </div>
                    <div class="form_field" id="otp-register-input-section" style="display: none;">
                        <label for="mobile_register_otp"><?php te( 'theme_enter_otp', 'Enter OTP' ); ?>:</label>
                        <div>
                            <input type="text" id="mobile_register_otp" name="otp" placeholder="123456" maxlength="6" required style="width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 5px; margin-bottom: 10px;" />
                            <input type="hidden" id="mobile_register_verification_id" name="verification_id" />
                            <button type="button" id="verify-otp-register-btn" class="button" style="width: 100%;"><?php te( 'theme_verify_register', 'Verify & Register' ); ?></button>
                            <button type="button" id="resend-otp-register-btn" class="button" style="width: 100%; margin-top: 10px; background: #999;"><?php te( 'theme_resend_otp', 'Resend OTP' ); ?></button>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="bottom-box text-left"><a href="<?php echo tlink( 'tpage/login' ); ?>"><i class="fas fa-angle-left"></i> <?php te( 'theme_login_button', 'Sign In' ); ?></a></div>
        </div>
        
        <?php if( ( $facebook_login = facebook_login() ) || google_login() ) { ?>
        <div class="social-login-box" style="margin-top: 30px; text-align: center;">
            <div style="margin-bottom: 15px; color: #666; font-size: 14px;"><?php te( 'theme_or_register_with', 'Or register with' ); ?></div>
            <div class="social-login-buttons" style="display: flex; gap: 15px; justify-content: center; flex-wrap: wrap;">
                <?php if( $facebook_login ) { ?>
                <a href="<?php echo tlink( 'plugin/facebook_login' ); ?>" class="social-login-btn social-login-facebook" style="display: inline-flex; align-items: center; gap: 8px; padding: 12px 24px; background: #1877f2; color: #fff; text-decoration: none; border-radius: 5px; font-weight: 500; transition: background 0.3s;">
                    <i class="fab fa-facebook-f"></i>
                    <span><?php te( 'theme_register_with_facebook', 'Register with Facebook' ); ?></span>
                </a>
                <?php } if( google_login() ) { ?>
                <a href="<?php echo tlink( 'plugin/google_login' ); ?>" class="social-login-btn social-login-google" style="display: inline-flex; align-items: center; gap: 8px; padding: 12px 24px; background: #db4437; color: #fff; text-decoration: none; border-radius: 5px; font-weight: 500; transition: background 0.3s;">
                    <i class="fab fa-google"></i>
                    <span><?php te( 'theme_register_with_google', 'Register with Google' ); ?></span>
                </a>
                <?php } ?>
            </div>
        </div>
        <?php } ?>
    </div>
</div>