<?php if(getCodeParams()): ?>
<!-- Coupon Modal Redesign CSS loaded in header-css.php -->

<div class="uk-open" id="singleModal" uk-modal style="display: block;" tabindex="-1">
<div class="tas-modal coupon-modal uk-modal-dialog uk-modal-body">
<button class="uk-modal-close-default c-close" type="button" uk-close></button>

<?php if(empty($couponDetails)):  ?>
    <div class="modal-body-section">
        <p class="uk-text-center"><?php echo echoOutput($translation['tr_37']); ?></p>
    </div>
<?php endif; ?>

<?php if(!empty($couponDetails)):  ?>

    <!-- Modal Header with Store Logo and Title -->
    <div class="modal-header-section">
        <img class="image" src="<?php echo $urlPath->image($couponDetails['store_image']); ?>" alt="<?php echo echoOutput($couponDetails['store_title']); ?>">
        <h2 class="title"><?php echo echoOutput($couponDetails['coupon_title']); ?></h2>
        <?php if(!empty($couponDetails['coupon_code'])):  ?>
            <p><?php echo echoOutput($translation['tr_23']); ?> <a href="<?php echo $urlPath->redirect($couponDetails['coupon_id']); ?>" target="_blank"><?php echo echoOutput($couponDetails['store_title']); ?></a></p>
        <?php else: ?>
            <p><?php echo echoOutput($translation['tr_89']); ?></p>
        <?php endif; ?>
    </div>

    <!-- Modal Body -->
    <div class="modal-body-section">
        
        <?php if(!empty($couponDetails['coupon_code'])):  ?>
            <!-- Coupon Code Section -->
            <div class="coupon">
                <div><p class="uk-text-secondary uk-text-bold"><?php echo echoOutput($couponDetails['coupon_code']); ?></p></div>
                <div>
                    <a class="uk-button uk-button-primary uk-border-pill uk-text-bold copy" 
                       data-clipboard-text="<?php echo echoOutput($couponDetails['coupon_code']); ?>" 
                       data-copy="<?php echo echoOutput($translation['tr_87']); ?>" 
                       data-copied="<?php echo echoOutput($translation['tr_119']); ?>"
                       data-redirect="<?php echo $urlPath->redirect($couponDetails['coupon_id']); ?>">
                        <?php echo echoOutput($translation['tr_87']); ?>
                    </a>
                </div>
            </div>

            <!-- Likes Section -->
            <?php if(isset($isLike)): ?>
                <?php if($isLike === false || $isLike == 0): ?>
                    <div class="uk-grid-small uk-flex uk-flex-middle uk-flex-center likes" uk-grid>
                        <div><p class="uk-text-small"><?php echo echoOutput($translation['tr_204']); ?></p></div>
                        <div>
                            <a class="deslike coupon_deslike uk-text-secondary" data-item="<?php echo echoOutput($couponDetails['coupon_id']); ?>">
                                <i class="fas fa-thumbs-down"></i> <?php echo echoOutput($translation['tr_206']); ?>
                            </a>
                            <a class="like coupon_like uk-text-secondary" data-item="<?php echo echoOutput($couponDetails['coupon_id']); ?>">
                                <i class="fas fa-thumbs-up"></i> <?php echo echoOutput($translation['tr_205']); ?>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>

                <p class="uk-text-small thanks uk-hidden"><?php echo echoOutput($translation['tr_207']); ?></p>

                <?php if($isLike === true || $isLike == 1): ?>
                    <p class="uk-text-small uk-text-center"><?php echo echoOutput($translation['tr_207']); ?></p>
                <?php endif; ?>
            <?php endif; ?>
        <?php endif; ?>

        <?php if(empty($couponDetails['coupon_code'])):  ?>
            <!-- Deal Button (No Code) -->
            <div class="uk-text-center">
                <a href="<?php echo $urlPath->redirect($couponDetails['coupon_id']); ?>" target="_blank" class="uk-button uk-button-primary uk-border-pill uk-text-bold deal-button">
                    <i class="ti ti-shopping-cart"></i>
                    <?php echo echoOutput($translation['tr_98']); ?>
                </a>
            </div>
        <?php endif; ?>

        <hr>
        
        <div class="share-section">
            <?php require './sections/views/share.view.php'; ?>
        </div>
    </div>

<?php endif; ?>

<?php if(!empty($modalAD)): ?>
    <div class="modal-body-section">
        <hr>
        <?php echo $modalAD['ad_html']; ?>
    </div>
<?php endif; ?>

</div>
</div>

<?php endif; ?>
