<?php

require './core.php';

header('Content-Type: application/json');

// Check if push notifications are enabled
$push_settings = $connect->query("SELECT * FROM push_notification_settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

if (!$push_settings || !$push_settings['notification_enabled']) {
    echo json_encode(['success' => false, 'message' => 'Push notifications are not enabled']);
    exit;
}

// Get POST data
$data = json_decode(file_get_contents('php://input'), true);

$action = $data['action'] ?? '';
$store_id = intval($data['store_id'] ?? 0);
$player_id = $data['player_id'] ?? '';
$device_type = $data['device_type'] ?? 'web';
$user_id = isLogged() ? $userInfo['user_id'] : null;

if (empty($store_id) || empty($player_id)) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

// Verify store exists
$store_check = $connect->prepare("SELECT store_id, store_title FROM stores WHERE store_id = :store_id AND store_status = 1");
$store_check->execute([':store_id' => $store_id]);
$store = $store_check->fetch(PDO::FETCH_ASSOC);

if (!$store) {
    echo json_encode(['success' => false, 'message' => 'Store not found']);
    exit;
}

try {
    if ($action === 'follow') {
        // Check if already following
        $check = $connect->prepare("SELECT id FROM store_followers WHERE store_id = :store_id AND player_id = :player_id");
        $check->execute([':store_id' => $store_id, ':player_id' => $player_id]);
        
        if ($check->fetch()) {
            echo json_encode(['success' => true, 'message' => 'Already following', 'following' => true]);
            exit;
        }
        
        // Add follower
        $insert = $connect->prepare("INSERT INTO store_followers (store_id, user_id, player_id, device_type) VALUES (:store_id, :user_id, :player_id, :device_type)");
        $insert->execute([
            ':store_id' => $store_id,
            ':user_id' => $user_id,
            ':player_id' => $player_id,
            ':device_type' => $device_type
        ]);
        
        echo json_encode([
            'success' => true, 
            'message' => 'Successfully followed ' . $store['store_title'],
            'following' => true
        ]);
        
    } elseif ($action === 'unfollow') {
        // Remove follower
        $delete = $connect->prepare("DELETE FROM store_followers WHERE store_id = :store_id AND player_id = :player_id");
        $delete->execute([':store_id' => $store_id, ':player_id' => $player_id]);
        
        echo json_encode([
            'success' => true, 
            'message' => 'Unfollowed ' . $store['store_title'],
            'following' => false
        ]);
        
    } elseif ($action === 'check') {
        // Check if following
        $check = $connect->prepare("SELECT id FROM store_followers WHERE store_id = :store_id AND player_id = :player_id");
        $check->execute([':store_id' => $store_id, ':player_id' => $player_id]);
        $is_following = $check->fetch() ? true : false;
        
        echo json_encode([
            'success' => true,
            'following' => $is_following
        ]);
        
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid action']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}

?>
