<?php require'sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _EDITITEM; ?></h5>
            </div>
          </div>

          <div class="col-md-12">

            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post">

               <input type="hidden" value="<?php echo $slider['slider_id']; ?>" name="slider_id">

               <div class="form-row">
                <div class="form-group col-md-9">
                  <div class="block col-md-12">

                    <label class="required"><?php echo _TABLEFIELDURLLINK; ?></label>
                    <input type="text" value="<?php echo $slider['slider_link']; ?>" name="slider_link" class="form-control" require>

                    <label><?php echo _TABLEFIELDIMAGE; ?></label>

                    <div class="new-image" id="image-preview" style="width: 500px; height: 200px; background: url(../../images/<?php echo $slider['slider_image'] ?>);">
                    <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                    <input type="hidden" value="<?php echo $slider['slider_image']; ?>" name="slider_image_save">
                    <input type="file" name="slider_image" id="image-upload" />
                    </div>

                    <span class="text-danger recomendedsize"><?php echo _RECOMMENDEDSIZE; ?> <b>920 x 360</b> </span>
                    <br/>

                    <!-- CDN Image Settings -->
                    <fieldset style="border: 1px solid #ddd; padding: 15px; border-radius: 8px; background: #f8f9fa; margin-top: 15px;">
                      <legend style="font-size: 14px; font-weight: bold; color: #007bff;">
                        <i class="fa fa-cloud"></i> CDN Image Settings
                      </legend>
                      
                      <div class="form-group">
                        <label>CDN Image URL</label>
                        <input type="url" name="slider_image_cdn_url" id="cdn_image_url" class="form-control" 
                               value="<?php echo isset($slider['slider_image_cdn_url']) ? htmlspecialchars($slider['slider_image_cdn_url']) : ''; ?>" 
                               placeholder="https://cdn.example.com/sliders/slider-image.jpg"
                               oninput="previewCDNImage()">
                        <small class="form-text text-muted">
                          <i class="fa fa-info-circle"></i> Enter the CDN URL for this slider image
                        </small>
                      </div>
                      
                      <div class="form-group" style="margin-top: 15px;">
                        <label style="display: flex; align-items: center; cursor: pointer; padding: 10px; background: white; border: 1px solid #ddd; border-radius: 4px;">
                          <input type="checkbox" id="slider_use_cdn" name="slider_use_cdn" value="1"
                                 style="width: 20px; height: 20px; margin-right: 10px; cursor: pointer;"
                                 onchange="previewCDNImage()"
                                 <?php echo (isset($slider['slider_use_cdn']) && $slider['slider_use_cdn'] == 1) ? 'checked' : ''; ?>>
                          <span style="font-weight: bold; font-size: 14px;">
                            <i class="fa fa-check-circle" style="color: #28a745;"></i> USE CDN IMAGE
                          </span>
                        </label>
                        <small class="form-text text-muted" style="margin-top: 8px;">
                          When enabled, the CDN URL will be used instead of the local image
                        </small>
                      </div>
                      
                      <!-- Image Preview -->
                      <div id="cdn_preview" style="margin-top: 15px; display: none;">
                        <label style="font-weight: bold; color: #28a745;">
                          <i class="fa fa-eye"></i> CDN Image Preview:
                        </label>
                        <div style="border: 2px solid #28a745; border-radius: 8px; padding: 10px; background: white; text-align: center;">
                          <img id="cdn_preview_img" src="" alt="CDN Preview" style="max-width: 100%; max-height: 300px; border-radius: 4px;">
                        </div>
                      </div>
                      
                      <!-- Current Local Image -->
                      <?php if(!empty($slider['slider_image'])): ?>
                      <div style="margin-top: 15px;">
                        <label style="font-weight: bold; color: #6c757d;">
                          <i class="fa fa-image"></i> Current Local Image:
                        </label>
                        <div style="border: 1px solid #ddd; border-radius: 8px; padding: 10px; background: white; text-align: center;">
                          <img src="<?php echo SITE_URL . '/images/' . $slider['slider_image']; ?>" alt="Current Image" style="max-width: 100%; max-height: 300px; border-radius: 4px;">
                        </div>
                      </div>
                      <?php endif; ?>
                    </fieldset>
                    
                    <script>
                    function previewCDNImage() {
                      const cdnUrl = document.getElementById('cdn_image_url').value;
                      const useCdn = document.getElementById('slider_use_cdn').checked;
                      const preview = document.getElementById('cdn_preview');
                      const previewImg = document.getElementById('cdn_preview_img');
                      
                      if (cdnUrl && useCdn) {
                        previewImg.src = cdnUrl;
                        preview.style.display = 'block';
                      } else {
                        preview.style.display = 'none';
                      }
                    }
                    
                    // Show preview on page load if CDN is enabled
                    document.addEventListener('DOMContentLoaded', function() {
                      previewCDNImage();
                    });
                    </script>

                  </div>
                </div>

                <div class="form-group col-md-3 sidebar">

                 <div class="block col-md-12">
                   <label><?php echo _TABLEFIELDSTATUS; ?></label>

                   <select class="custom-select form-control" name="slider_status">

                    <?php
                    if($slider['slider_status'] == 1){
                      echo '<option value="1" selected="selected">'._ENABLED.'</option>';
                      echo '<option value="0">'._DISABLED.'</option>';

                    } else{
                      echo '<option value="0" selected="selected">'._DISABLED.'</option>';
                      echo '<option value="1">'._ENABLED.'</option>';
                    }
                    ?>
                  </select>

                </div>

                <button class="btn btn-primary" type="submit" name="save"><?php echo _UPDATEITEM; ?></button>
                <button class="btn btn-danger deleteItem" type="button" data-url="../controller/delete_slider.php?id=<?php echo $slider['slider_id']; ?>" data-redirect="../controller/categories.php"><?php echo _DELETEITEM; ?></button>

              </div>
            </div>

          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</div>
</section>
