<?php require 'sidebar.php'; ?>

<!--Page Container--> 
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        <div class="row">
          <div class="col-12">
            <div class="section-title">
              <h5><?php echo _EDITITEM; ?> - Campaign</h5>
            </div>
          </div>

          <div class="col-md-12">
            <div class="form-block mb-4">

              <form enctype="multipart/form-data" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']) . '?id=' . $campaign_id; ?>" method="post">

                <div class="form-row">
                  <div class="form-group col-md-9">
                    <div class="block col-md-12">

                      <label><?php echo _TABLEFIELDTITLE; ?> (Optional)</label>
                      <input type="text" placeholder="e.g., Amazon Beauty Sale" name="campaign_title" class="form-control" value="<?php echo htmlspecialchars($campaign['campaign_title']); ?>">

                      <br>

                      <label>Select Store (Optional)</label>
                      <select class="form-control" name="campaign_store">
                          <option value="">-- No Store --</option>
                          <?php foreach ($stores as $store): ?>
                              <option value="<?php echo $store['store_id']; ?>" <?php echo ($campaign['campaign_store'] == $store['store_id']) ? 'selected' : ''; ?>>
                                  <?php echo htmlspecialchars($store['store_title']); ?>
                              </option>
                          <?php endforeach; ?>
                      </select>

                      <br>

                      <label>Campaign Link (Optional)</label>
                      <input type="url" placeholder="https://example.com/campaign" name="campaign_link" class="form-control" value="<?php echo htmlspecialchars($campaign['campaign_link']); ?>">
                      <small class="form-text text-muted">External link for the campaign</small>

                      <br>

                      <label class="required"><?php echo _TABLEFIELDIMAGE; ?></label>
                      
                      <?php if ($campaign['campaign_image']): ?>
                      <div class="mb-3">
                          <img src="../../images/<?php echo htmlspecialchars($campaign['campaign_image']); ?>" alt="Current Image" style="max-width: 500px; height: auto; border-radius: 8px;">
                      </div>
                      <?php endif; ?>
                      
                      <div class="new-image" id="image-preview" style="width: 500px; height: 200px;">
                        <label for="image-upload" id="image-label"><?php echo _CHOOSEFILE; ?></label>
                        <input type="file" name="campaign_image" id="image-upload" accept="image/*" />
                      </div>
                      <small class="form-text text-muted">Recommended size: 1200x400px (Leave empty to keep current image)</small>

                      <br><br>

                      <!-- CDN Image Settings -->
                      <fieldset style="border: 1px solid #ddd; padding: 15px; border-radius: 8px; background: #f8f9fa;">
                        <legend style="font-size: 14px; font-weight: bold; color: #007bff;">
                          <i class="fa fa-cloud"></i> CDN Image Settings
                        </legend>
                        
                        <div class="form-group">
                          <label>CDN Image URL</label>
                          <input type="url" name="campaign_image_cdn_url" class="form-control" 
                                 value="<?php echo isset($campaign['campaign_image_cdn_url']) ? htmlspecialchars($campaign['campaign_image_cdn_url']) : ''; ?>" 
                                 placeholder="https://cdn.example.com/campaigns/campaign-image.jpg">
                          <small class="form-text text-muted">
                            <i class="fa fa-info-circle"></i> Enter the CDN URL for this campaign image
                          </small>
                        </div>
                        
                        <div class="form-group mb-0">
                          <label style="display: flex; align-items: center; cursor: pointer;">
                            <input type="checkbox" id="campaign_use_cdn" name="campaign_use_cdn" value="1"
                                   style="width: 20px; height: 20px; margin-right: 10px; cursor: pointer;"
                                   <?php echo (isset($campaign['campaign_use_cdn']) && $campaign['campaign_use_cdn'] == 1) ? 'checked' : ''; ?>>
                            <span style="font-weight: bold;">Use CDN Image</span>
                          </label>
                          <small class="form-text text-muted" style="margin-left: 30px;">
                            When enabled, the CDN URL will be used instead of the local image
                          </small>
                        </div>
                      </fieldset>

                    </div>
                  </div>

                  <div class="form-group col-md-3">
                    <div class="block col-md-12">

                      <label>Display Order</label>
                      <input type="number" name="campaign_order" value="<?php echo $campaign['campaign_order']; ?>" min="0" class="form-control">
                      <small class="form-text text-muted">Lower numbers appear first</small>

                      <br>

                      <label class="required"><?php echo _TABLEFIELDSTATUS; ?></label>
                      <select class="form-control" name="campaign_status">
                        <option value="1" <?php echo ($campaign['campaign_status'] == 1) ? 'selected' : ''; ?>><?php echo _ACTIVE; ?></option>
                        <option value="0" <?php echo ($campaign['campaign_status'] == 0) ? 'selected' : ''; ?>><?php echo _INACTIVE; ?></option>
                      </select>

                      <br>

                      <label>Show in Sidebar</label>
                      <select class="form-control" name="campaign_sidebar">
                        <option value="1" <?php echo ($campaign['campaign_sidebar'] == 1) ? 'selected' : ''; ?>>Yes</option>
                        <option value="0" <?php echo ($campaign['campaign_sidebar'] == 0) ? 'selected' : ''; ?>>No</option>
                      </select>
                      <small class="form-text text-muted">Display in search/category sidebar</small>

                      <br>

                      <button type="submit" class="btn btn-primary btn-block">
                        <i class="fa fa-check"></i> <?php echo _UPDATEITEM; ?>
                      </button>

                      <a href="./campaigns.php" class="btn btn-default btn-block">
                        Cancel
                      </a>

                    </div>
                  </div>
                </div>

              </form>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
