<?php
session_start();

if (!isset($_SESSION['user_email'])){
    die("Please login first");
}

require '../config.php';
require 'functions.php';

$connect = connect($database);

// Get a store ID from URL or use first store
$store_id = isset($_GET['id']) ? (int)$_GET['id'] : null;

if (!$store_id) {
    // Get first store
    $query = $connect->query("SELECT store_id FROM stores LIMIT 1");
    $first_store = $query->fetch();
    if ($first_store) {
        $store_id = $first_store['store_id'];
    } else {
        die("No stores found in database");
    }
}

echo "<h2>Store CDN Field Test</h2>";
echo "<p>Testing Store ID: <strong>$store_id</strong></p>";

// Check if CDN columns exist
echo "<h3>1. Checking if CDN columns exist in stores table:</h3>";
$columns_query = $connect->query("SHOW COLUMNS FROM stores LIKE '%cdn%'");
$cdn_columns = $columns_query->fetchAll();

if (count($cdn_columns) > 0) {
    echo "<p style='color: green;'>✓ CDN columns found:</p>";
    echo "<ul>";
    foreach ($cdn_columns as $col) {
        echo "<li><strong>{$col['Field']}</strong> - Type: {$col['Type']}, Default: {$col['Default']}</li>";
    }
    echo "</ul>";
} else {
    echo "<p style='color: red;'>✗ CDN columns NOT found! Please run this SQL:</p>";
    echo "<pre>ALTER TABLE `stores` 
ADD COLUMN `store_image_cdn_url` VARCHAR(500) DEFAULT '' COMMENT 'CDN image URL',
ADD COLUMN `store_use_cdn` TINYINT(1) DEFAULT 0 COMMENT 'Use CDN (1=yes, 0=no)';</pre>";
}

// Get store data
echo "<h3>2. Fetching store data:</h3>";
$store_query = $connect->prepare("SELECT * FROM stores WHERE store_id = :id LIMIT 1");
$store_query->execute(array(':id' => $store_id));
$store = $store_query->fetch(PDO::FETCH_ASSOC);

if ($store) {
    echo "<p style='color: green;'>✓ Store found: <strong>{$store['store_title']}</strong></p>";
    
    echo "<h4>Store Image Fields:</h4>";
    echo "<ul>";
    echo "<li><strong>store_image:</strong> " . htmlspecialchars($store['store_image']) . "</li>";
    
    if (isset($store['store_image_cdn_url'])) {
        echo "<li><strong>store_image_cdn_url:</strong> " . htmlspecialchars($store['store_image_cdn_url']) . "</li>";
    } else {
        echo "<li style='color: red;'><strong>store_image_cdn_url:</strong> FIELD NOT FOUND IN QUERY RESULT</li>";
    }
    
    if (isset($store['store_use_cdn'])) {
        echo "<li><strong>store_use_cdn:</strong> " . $store['store_use_cdn'] . " (" . ($store['store_use_cdn'] == 1 ? 'Enabled' : 'Disabled') . ")</li>";
    } else {
        echo "<li style='color: red;'><strong>store_use_cdn:</strong> FIELD NOT FOUND IN QUERY RESULT</li>";
    }
    echo "</ul>";
    
    // Test getImageUrl function
    if (isset($store['store_image_cdn_url']) && isset($store['store_use_cdn'])) {
        echo "<h3>3. Testing getImageUrl() function:</h3>";
        
        require '../functions.php';
        $result_url = getImageUrl($store['store_image_cdn_url'], $store['store_use_cdn'], $store['store_image']);
        
        echo "<p><strong>Result URL:</strong> " . htmlspecialchars($result_url) . "</p>";
        
        if ($store['store_use_cdn'] == 1 && !empty($store['store_image_cdn_url'])) {
            echo "<p style='color: green;'>✓ Should display CDN image</p>";
            echo "<img src='" . htmlspecialchars($result_url) . "' style='max-width: 300px; border: 2px solid green;' alt='CDN Image'>";
        } else {
            echo "<p style='color: orange;'>⚠ Should display local image (CDN not enabled or URL empty)</p>";
            echo "<img src='" . htmlspecialchars($result_url) . "' style='max-width: 300px; border: 2px solid orange;' alt='Local Image'>";
        }
    }
    
} else {
    echo "<p style='color: red;'>✗ Store not found</p>";
}

echo "<hr>";
echo "<p><a href='controller/stores.php'>← Back to Stores</a></p>";
?>
