<?php 

session_start();
if (isset($_SESSION['user_email'])){   
	
	require '../../config.php';
	require '../functions.php';

	$connect = connect($database);
	if(!$connect){
		header('Location: ./error.php');
	} 

	$check_access = check_access($connect);

	if ($check_access['user_role'] == 1 || $check_access['user_role'] == 2){

		if ($_SERVER['REQUEST_METHOD'] == 'POST'){

			$product_title = cleardata($_POST['product_title']);
			$product_description = $_POST['product_description'];
			$product_store = cleardata($_POST['product_store']);
			$product_category = cleardata($_POST['product_category']);
			$product_affiliate_link = cleardata($_POST['product_affiliate_link']);
			$product_original_price = cleardata($_POST['product_original_price']);
			$product_sale_price = cleardata($_POST['product_sale_price']);
			$product_cashback = cleardata($_POST['product_cashback']);
			$product_featured = isset($_POST['product_featured']) ? 1 : 0;
			$product_status = cleardata($_POST['product_status']);
			$product_order = cleardata($_POST['product_order']);
			
			// CDN fields
			$product_use_cdn = isset($_POST['product_use_cdn']) ? 1 : 0;
			$product_image_cdn_url = cleardata($_POST['product_image_cdn_url']);

			// Calculate discount percentage
			$product_discount_percentage = 0;
			if ($product_original_price > 0 && $product_sale_price > 0 && $product_sale_price < $product_original_price) {
				$product_discount_percentage = round((($product_original_price - $product_sale_price) / $product_original_price) * 100);
			}

			// Handle image upload
			if($_FILES['product_image']['error'] > 0 || empty($_FILES['product_image'])) {
				$product_image = '';
			} else {
				$extsAllowed = array('jpg', 'jpeg', 'png', 'gif', 'webp');
				$extUpload = strtolower(substr(strrchr($_FILES['product_image']['name'], '.'), 1));
	 
				if (in_array($extUpload, $extsAllowed)) { 
					$image = $_FILES['product_image']['tmp_name'];
					$imagefile = explode(".", $_FILES["product_image"]["name"]);
					$renamefile = round(microtime(true)) . '.' . end($imagefile);
					$image_upload = '../../images/';
					move_uploaded_file($image, $image_upload . 'product_' . $renamefile);
					$product_image = 'product_' . $renamefile;
				}
			}
			
			$statment = $connect->prepare("INSERT INTO products (
				product_id,
				product_title,
				product_description,
				product_image,
				product_image_cdn_url,
				product_use_cdn,
				product_store,
				product_category,
				product_affiliate_link,
				product_original_price,
				product_sale_price,
				product_discount_percentage,
				product_cashback,
				product_featured,
				product_status,
				product_order,
				product_created
			) VALUES (
				null,
				:product_title,
				:product_description,
				:product_image,
				:product_image_cdn_url,
				:product_use_cdn,
				:product_store,
				:product_category,
				:product_affiliate_link,
				:product_original_price,
				:product_sale_price,
				:product_discount_percentage,
				:product_cashback,
				:product_featured,
				:product_status,
				:product_order,
				CURRENT_TIMESTAMP
			)");

			$statment->execute(array(
				':product_title' => $product_title,
				':product_description' => $product_description,
				':product_image' => $product_image,
				':product_image_cdn_url' => $product_image_cdn_url,
				':product_use_cdn' => $product_use_cdn,
				':product_store' => $product_store,
				':product_category' => $product_category,
				':product_affiliate_link' => $product_affiliate_link,
				':product_original_price' => $product_original_price,
				':product_sale_price' => $product_sale_price,
				':product_discount_percentage' => $product_discount_percentage,
				':product_cashback' => $product_cashback,
				':product_featured' => $product_featured,
				':product_status' => $product_status,
				':product_order' => $product_order
			));

			header('Location: ./products.php');
		}

		$stores = get_all_stores($connect);
		$categories = get_all_categories($connect);
		$siteSettings = getSettings($connect);
		
		require '../views/header.view.php';
		require '../views/new.product.view.php';
		
	}else{
		
		header('Location:'.SITE_URL);
	}

	require '../views/footer.view.php';
	
}else {
	header('Location: ./login.php');		
}


?>
