# Fix CORS Errors - CDN Configuration

You're seeing CORS errors because your CDN subdomain (assets.alonedeals.com) is not configured to allow requests from your main domain (www.alonedeals.com).

## Quick Fix Options

### Option 1: Add CORS Headers to CDN Server (RECOMMENDED)

Create or edit `.htaccess` file on your CDN server (assets.alonedeals.com):

```apache
<IfModule mod_headers.c>
    # Allow requests from your main domain
    Header set Access-Control-Allow-Origin "https://www.alonedeals.com"
    Header set Access-Control-Allow-Methods "GET, OPTIONS"
    Header set Access-Control-Allow-Headers "Content-Type"
    
    # Cache the CORS preflight for 1 hour
    Header set Access-Control-Max-Age "3600"
</IfModule>

# Enable CORS for fonts
<FilesMatch "\.(ttf|otf|eot|woff|woff2)$">
    <IfModule mod_headers.c>
        Header set Access-Control-Allow-Origin "*"
    </IfModule>
</FilesMatch>
```

### Option 2: Allow All Origins (Less Secure)

If you want to allow all domains to access your CDN:

```apache
<IfModule mod_headers.c>
    Header set Access-Control-Allow-Origin "*"
</IfModule>
```

### Option 3: Disable CDN Temporarily

If you want to disable the CDN and use local files:

1. Edit `views/includes/footer-js.php`
2. Change line 8 from:
   ```php
   $cdn_js_url = 'https://assets.alonedeals.com/assets/js';
   ```
   To:
   ```php
   $cdn_js_url = ''; // Disabled - use local files
   ```

3. Edit `views/includes/header-css.php`
4. Make sure line 8 is:
   ```php
   $cdn_css_url = ''; // Already disabled
   ```

## Where to Add the .htaccess File

1. **If assets.alonedeals.com is a subdomain pointing to a folder:**
   - Add `.htaccess` to the root of that folder
   - Example: `/public_html/assets/.htaccess`

2. **If assets.alonedeals.com is a separate server:**
   - Add `.htaccess` to the document root
   - Example: `/var/www/html/.htaccess`

3. **If using cPanel:**
   - Go to File Manager
   - Navigate to the assets.alonedeals.com directory
   - Create/edit `.htaccess` file
   - Make sure "Show Hidden Files" is enabled

## Testing the Fix

After adding the CORS headers:

1. Clear your browser cache (Ctrl+Shift+Delete)
2. Reload your website
3. Open Developer Console (F12)
4. Check if CORS errors are gone

## Additional Notes

- The CORS errors are specifically for:
  - CSS files (sidenav-redesign.css)
  - Font files (tabler-icons.woff, tabler-icons.woff2, tabler-icons.ttf)
  - Image files (PNG images)

- All these resources need CORS headers to load from a different domain

- If you're using Cloudflare or another CDN service, you may need to configure CORS in their dashboard instead
