<!-- BreadcrumbList Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "<?php echo SITE_URL; ?>"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Categories",
      "item": "<?php echo SITE_URL; ?>/categories"
    },
    <?php if ($parentCategory && !empty($parentCategory['category_slug'])): ?>
    {
      "@type": "ListItem",
      "position": 3,
      "name": "<?php echo echoOutput($parentCategory['category_title']); ?>",
      "item": "<?php echo SITE_URL . '/category/' . $parentCategory['category_slug']; ?>"
    },
    {
      "@type": "ListItem",
      "position": 4,
      "name": "<?php echo echoOutput($itemDetails['subcategory_title']); ?>",
      "item": "<?php echo $canonicalUrl; ?>"
    }
    <?php else: ?>
    {
      "@type": "ListItem",
      "position": 3,
      "name": "<?php echo echoOutput($itemDetails['subcategory_title']); ?>",
      "item": "<?php echo $canonicalUrl; ?>"
    }
    <?php endif; ?>
  ]
}
</script>

<!-- CollectionPage Schema -->
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "CollectionPage",
  "name": "<?php echo echoOutput($itemDetails['subcategory_title']); ?> Coupons and Offers",
  "description": "<?php echo echoOutput($itemDetails['subcategory_description']); ?>",
  "url": "<?php echo $canonicalUrl; ?>",
  "numberOfItems": <?php echo $total; ?>
}
</script>

<div class="uk-container page uk-margin-medium-top">
    <div class="uk-grid-large" uk-grid>

        <!-- SIDEBAR -->
        <div class="uk-width-1-1 uk-width-1-4@m sidebar uk-visible@m">
        
            <?php require './sections/views/search-form.view.php'; ?>

        </div>
        <!-- END SIDEBAR -->

        <!-- CONTENT -->
        <div class="uk-width-1-1 uk-width-expand@m content">

    <!-- Subcategory Header -->
    <div class="uk-margin-medium-bottom">
        <h1 class="uk-text-bold uk-margin-small-bottom" style="font-size: 32px; color: #333;">
            <?php echo echoOutput($itemDetails['subcategory_title']); ?> Coupons and Offers
        </h1>
        <?php if(!empty($itemDetails['subcategory_description'])): ?>
        <p class="uk-text-large uk-margin-remove" style="font-size: 16px; font-weight: 600; color: #666;">
            <?php echo echoOutput($itemDetails['subcategory_description']); ?>
        </p>
        <?php endif; ?>
        <p class="uk-text-meta uk-margin-small-top">
            <?php echo $total; ?> active coupons
        </p>
    </div>

    <!-- Coupons List -->
    <?php if(!empty($items)): ?>
        <!-- Coupon Filter Tabs -->
        <div class="coupon-filter-tabs">
            <button class="coupon-filter-tab active" data-filter="all">
                All <span class="count">(<?php echo count($items); ?>)</span>
            </button>
            <button class="coupon-filter-tab" data-filter="coupon">
                Coupons <span class="count">(0)</span>
            </button>
            <button class="coupon-filter-tab" data-filter="cashback">
                Cashback <span class="count">(0)</span>
            </button>
            <button class="coupon-filter-tab" data-filter="deal">
                Deals <span class="count">(0)</span>
            </button>
        </div>

        <div class="uk-grid-medium uk-child-width-1-1" uk-grid>

        <?php foreach($items as $item): 
            // Determine coupon type
            $couponType = 'deal'; // default
            if (!empty($item['coupon_code'])) {
                $couponType = 'coupon';
            }
        ?>

            <div class="tas_card_5 coupon-item" data-coupon-type="<?php echo $couponType; ?>">
    <div class="uk-grid-collapse uk-margin card uk-flex uk-flex-middle" uk-grid>
        <div class="left uk-width-auto">

            <div class="uk-cover-container">
            <?php if($item['store_image']): ?>
            <img src="<?php echo $urlPath->image($item['store_image']); ?>" alt="<?php echo echoOutput($item['coupon_title']); ?>" uk-cover>
            <canvas width="60" height="60"></canvas>
            <?php endif; ?>
            <?php if(!$item['store_image']): ?>
            <div class="no-image"><i class="ti ti-percentage"></i></div>
            <?php endif; ?>

            </div>

        </div>
        <div class="body uk-width-expand">
        <div class="uk-grid-small" uk-grid>

            <div class="uk-width-1-1 uk-width-expand@s">
                <?php if(timeLeft(echoOutput($item['coupon_expire']))): ?>
                <p class="tas_time"><i class="ti ti-clock"></i> <span><?php echo timeLeft(echoOutput($item['coupon_expire'])); ?></span></p>
                <?php endif; ?>
                <h3 class="title"><?php echo echoOutput($item['coupon_title']); ?></h3>
            <?php if(!empty($item['coupon_tagline'])): ?>
                <p class="tagline"><?php echo echoOutput($item['coupon_tagline']); ?></p>
            <?php endif; ?>
            <p class="uk-text-meta uk-margin-small-top">
                <a href="<?php echo $urlPath->store($item['store_slug']); ?>" class="uk-link-text">
                    <?php echo echoOutput($item['store_title']); ?>
                </a>
            </p>
            </div>
            <div class="uk-width-1-1 uk-width-auto@s">
                <a class="uk-width-1-1@s uk-button btn c-open" data-id="<?php echo echoOutput($item['coupon_id']); ?>" data-redirect="<?php echo echoOutput($item['coupon_link']); ?>">
                <?php if(!empty($item['coupon_code'])): ?>
                    <i class="fas fa-cut"></i> Show Coupon
                <?php else: ?>
                    <i class="fas fa-tag"></i> Get Deal
                <?php endif; ?>
                </a>
            </div>

        </div>

        </div>

        <div class="uk-width-1-1 info">

        <div class="uk-grid-small uk-flex uk-flex-middle" uk-grid>

        <div class="uk-width-expand uk-text-left">
            <ul class="uk-subnav" uk-margin>
                <?php if(!empty(echoOutput($item['coupon_expire']))): ?>
                <li><span><?php echo echoOutput($translation['tr_24']); ?> <?php echo formatDate($item['coupon_expire']); ?></span></li>
                <?php endif; ?>
                <?php if(isVerified(echoOutput($item['coupon_verify']))): ?>
                <li><span><div class="verified"><i class="ti ti-check"></i> <?php echo echoOutput($translation['tr_26']); ?></div></span></li>
                <?php endif; ?>
                <?php if(isExclusive(echoOutput($item['coupon_exclusive']))): ?>
                <li><span><div class="exclusive"><i class="ti ti-crown"></i> <?php echo echoOutput($translation['tr_16']); ?></div></span></li>
                <?php endif; ?>
            </ul>
        </div>
        
        <div class="uk-width-auto uk-text-right">
                <button class="details-collapse-btn" onclick="toggleSubcategoryDetails(<?php echo echoOutput($item['coupon_id']); ?>)" id="subcategoryDetailsBtn_<?php echo echoOutput($item['coupon_id']); ?>">
                    <?php echo echoOutput($translation['tr_99']); ?> <i class="ti ti-chevron-down" id="subcategoryDetailsArrow_<?php echo echoOutput($item['coupon_id']); ?>"></i>
                </button>
        </div>

        </div>

        <div class="uk-width-1-1 details-collapse-section" id="toggle_<?php echo echoOutput($item['coupon_id']); ?>" style="display: none;">
            <p class="details"><?php echo echoOutput($item['coupon_description']); ?></p>
            <hr class="uk-margin-small">
            <p class="uk-margin-remove reaction uk-flex uk-flex-middle">
                <i class="fas fa-thumbs-up uk-text-success"></i> <span><?php echo echoOutput($item['total_likes']); ?></span>
                <i class="fas fa-thumbs-down uk-text-danger"></i> <span><?php echo echoOutput($item['total_deslikes']); ?></span>
            </p>
        </div>

    </div>
</div>
</div>

        <?php endforeach; ?>

        </div>

        <?php require './sections/pagination.php'; ?>
        
    <?php endif; ?>

    <?php if(empty($items)): ?>
        <div class="uk-width-1-1 uk-flex uk-flex-center uk-text-center uk-margin-large-top">
        <div class="uk-width-1-1 uk-width-1-2@s">
        <h3 class="uk-text-bold uk-margin-small"><?php echo echoOutput($translation['tr_109']); ?></h3>
        <p class="uk-margin-small">No active coupons found in this subcategory at the moment.</p>
        </div>
        </div>
    <?php endif; ?>

        </div>
        <!-- END CONTENT -->

    </div>
</div>

<?php if(getCodeParams()): ?>
<?php include './single-modal.php'; ?>
<?php endif; ?>

<script>
function toggleSubcategoryDetails(couponId) {
    const detailsSection = document.getElementById('toggle_' + couponId);
    const toggleBtn = document.getElementById('subcategoryDetailsBtn_' + couponId);
    const arrow = document.getElementById('subcategoryDetailsArrow_' + couponId);
    
    if (detailsSection.style.display === 'none') {
        detailsSection.style.display = 'block';
        toggleBtn.classList.add('active');
    } else {
        detailsSection.style.display = 'none';
        toggleBtn.classList.remove('active');
    }
}
</script>
