<div class="contact-us-page">
    <div class="uk-container">
        
        <!-- Page Header -->
        <div class="contact-header">
            <h1 class="contact-title">Get In Touch</h1>
            <p class="contact-subtitle">Have questions? We'd love to hear from you. Send us a message and we'll respond as soon as possible.</p>
        </div>

        <div class="contact-content" uk-grid>
            
            <!-- Contact Form -->
            <div class="uk-width-1-1 uk-width-2-3@m">
                <div class="contact-form-wrapper">
                    <form id="contactForm" class="contact-form">
                        
                        <div class="form-group">
                            <label for="contactName" class="form-label">
                                <i class="fas fa-user"></i> Your Name
                            </label>
                            <input type="text" 
                                   id="contactName" 
                                   name="name" 
                                   class="form-input" 
                                   placeholder="Enter your full name"
                                   required>
                        </div>

                        <div class="form-group">
                            <label for="contactEmail" class="form-label">
                                <i class="fas fa-envelope"></i> Email Address
                            </label>
                            <input type="email" 
                                   id="contactEmail" 
                                   name="email" 
                                   class="form-input" 
                                   placeholder="your.email@example.com"
                                   required>
                        </div>

                        <div class="form-group">
                            <label for="contactSubject" class="form-label">
                                <i class="fas fa-tag"></i> Subject
                            </label>
                            <input type="text" 
                                   id="contactSubject" 
                                   name="subject" 
                                   class="form-input" 
                                   placeholder="What is this about?"
                                   required>
                        </div>

                        <div class="form-group">
                            <label for="contactMessage" class="form-label">
                                <i class="fas fa-comment-dots"></i> Message
                            </label>
                            <textarea id="contactMessage" 
                                      name="message" 
                                      class="form-textarea" 
                                      rows="6" 
                                      placeholder="Tell us more about your inquiry..."
                                      required></textarea>
                        </div>

                        <button type="submit" class="btn-submit" id="submitBtn">
                            <span class="btn-text">Send Message</span>
                            <span class="btn-loader" style="display: none;">
                                <i class="fas fa-spinner fa-spin"></i> Sending...
                            </span>
                        </button>

                    </form>

                    <!-- Success Message -->
                    <div id="successMessage" class="success-message" style="display: none;">
                        <div class="success-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <h3>Message Sent Successfully!</h3>
                        <p>Thank you for contacting us. We'll get back to you soon.</p>
                        <button class="btn-new-message" onclick="resetForm()">Send Another Message</button>
                    </div>

                    <!-- Error Message -->
                    <div id="errorMessage" class="error-message" style="display: none;">
                        <div class="error-icon">
                            <i class="fas fa-exclamation-circle"></i>
                        </div>
                        <h3>Oops! Something went wrong</h3>
                        <p id="errorText">Please try again later.</p>
                        <button class="btn-try-again" onclick="hideError()">Try Again</button>
                    </div>
                </div>
            </div>

            <!-- Contact Info Sidebar -->
            <div class="uk-width-1-1 uk-width-1-3@m">
                <div class="contact-info-sidebar">
                    
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <h3>Email Us</h3>
                        <p><?php echo !empty($settings['st_email']) ? $settings['st_email'] : 'support@alonedeals.com'; ?></p>
                    </div>

                    <?php if (!empty($settings['st_phone'])): ?>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <h3>Call Us</h3>
                        <p><?php echo $settings['st_phone']; ?></p>
                    </div>
                    <?php endif; ?>

                    <?php if (!empty($settings['st_address'])): ?>
                    <div class="info-card">
                        <div class="info-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <h3>Visit Us</h3>
                        <p><?php echo $settings['st_address']; ?></p>
                    </div>
                    <?php endif; ?>

                    <div class="info-card social-card">
                        <h3>Follow Us</h3>
                        <div class="social-links">
                            <?php foreach($socialMedia as $item): ?>
                                <?php if (!empty($item['st_facebook'])): ?>
                                <a href="<?php echo $item['st_facebook']; ?>" target="_blank" class="social-link">
                                    <i class="fab fa-facebook"></i>
                                </a>
                                <?php endif; ?>
                                <?php if (!empty($item['st_twitter'])): ?>
                                <a href="<?php echo $item['st_twitter']; ?>" target="_blank" class="social-link">
                                    <i class="fab fa-twitter"></i>
                                </a>
                                <?php endif; ?>
                                <?php if (!empty($item['st_instagram'])): ?>
                                <a href="<?php echo $item['st_instagram']; ?>" target="_blank" class="social-link">
                                    <i class="fab fa-instagram"></i>
                                </a>
                                <?php endif; ?>
                                <?php if (!empty($item['st_linkedin'])): ?>
                                <a href="<?php echo $item['st_linkedin']; ?>" target="_blank" class="social-link">
                                    <i class="fab fa-linkedin"></i>
                                </a>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
</div>

<script>
document.getElementById('contactForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const form = this;
    const submitBtn = document.getElementById('submitBtn');
    const btnText = submitBtn.querySelector('.btn-text');
    const btnLoader = submitBtn.querySelector('.btn-loader');
    
    // Show loader
    btnText.style.display = 'none';
    btnLoader.style.display = 'inline-block';
    submitBtn.disabled = true;
    
    // Get form data
    const formData = new FormData(form);
    
    // Send AJAX request
    fetch('submit_contact.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Hide form and show success message
            form.style.display = 'none';
            document.getElementById('successMessage').style.display = 'block';
            
            // Add animation
            document.getElementById('successMessage').classList.add('animate-in');
        } else {
            // Show error message
            document.getElementById('errorText').textContent = data.message || 'Please try again later.';
            document.getElementById('errorMessage').style.display = 'block';
            document.getElementById('errorMessage').classList.add('animate-in');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        document.getElementById('errorText').textContent = 'Network error. Please check your connection.';
        document.getElementById('errorMessage').style.display = 'block';
        document.getElementById('errorMessage').classList.add('animate-in');
    })
    .finally(() => {
        // Reset button
        btnText.style.display = 'inline-block';
        btnLoader.style.display = 'none';
        submitBtn.disabled = false;
    });
});

function resetForm() {
    document.getElementById('contactForm').reset();
    document.getElementById('contactForm').style.display = 'block';
    document.getElementById('successMessage').style.display = 'none';
    document.getElementById('successMessage').classList.remove('animate-in');
}

function hideError() {
    document.getElementById('errorMessage').style.display = 'none';
    document.getElementById('errorMessage').classList.remove('animate-in');
}
</script>
