<div class="uk-container uk-margin-medium-top uk-margin-large-bottom" uk-scrollspy="target: > div; cls: uk-animation-fade; delay: 100">
<!-- Homepage Featured Offers CSS loaded in header-css.php -->

    <div class="tas_heading uk-grid-collapse uk-flex uk-flex-middle" uk-grid>
        <div class="uk-width-expand">
            <h3 class="uk-heading-line uk-text-left">
                <span class="section-title-with-icon">
                    <span class="section-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"></circle>
                            <path d="M12 6v6l4 2"></path>
                        </svg>
                    </span>
                    Popular Offers
                </span>
            </h3>
        </div>
        <div class="uk-width-auto">
            <a href="<?php echo $urlPath->search(['filter' => 'exclusive']); ?>" class="uk-button uk-button-default uk-border-pill btn">
                <?php echo echoOutput($translation['tr_21']); ?>
                <i class="ti ti-chevron-right"></i>
            </a>
        </div>
    </div>

    <div class="swiper homepage-popular-swiper">
        <div class="swiper-wrapper">

<?php foreach($exclusiveCoupons as $item): ?>

            <div class="swiper-slide">
                <a href="<?php echo $urlPath->redirect($item['coupon_id']); ?>" class="uk-link-reset">
                    <div class="homepage-offer-card">
                        <img class="homepage-offer-logo" src="<?php echo getImageUrl($item['store_image_cdn_url'], $item['store_use_cdn'], $item['store_image']); ?>" alt="<?php echo echoOutput($item['store_title']); ?>">
                        <div class="homepage-offer-store-name"><?php echo echoOutput($item['store_title']); ?></div>
                        <h4 class="homepage-offer-title"><?php echo echoOutput($item['coupon_title']); ?></h4>
                        <div class="homepage-offer-badge">
                            <i class="ti ti-star"></i> Popular
                        </div>
                    </div>
                </a>
            </div>

<?php endforeach; ?>

        </div>
        <!-- Navigation buttons -->
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
        <!-- Pagination -->
        <div class="swiper-pagination"></div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Check if element exists before initializing
    if (document.querySelector('.homepage-popular-swiper')) {
        new Swiper('.homepage-popular-swiper', {
            slidesPerView: 1.5,
            spaceBetween: 16,
            centeredSlides: false,
            loop: true,
            loopAdditionalSlides: 3,
            autoplay: {
                delay: 3500,
                disableOnInteraction: false,
                pauseOnMouseEnter: true
            },
            navigation: {
                nextEl: '.homepage-popular-swiper .swiper-button-next',
                prevEl: '.homepage-popular-swiper .swiper-button-prev',
            },
            pagination: {
                el: '.homepage-popular-swiper .swiper-pagination',
                clickable: true,
            },
            breakpoints: {
                480: {
                    slidesPerView: 2,
                    spaceBetween: 16,
                },
                640: {
                    slidesPerView: 3,
                    spaceBetween: 16,
                },
                960: {
                    slidesPerView: 4,
                    spaceBetween: 20,
                },
                1200: {
                    slidesPerView: 5,
                    spaceBetween: 20,
                }
            }
        });
    }
});
</script>
