<?php
/**
 * Category-wise Product Sliders
 * Displays products grouped by specific categories with Swiper sliders
 */

// Define categories to display with custom titles
$displayCategories = [
    2 => [
        'name' => 'Fashion',
        'title' => 'Fashion Products'
    ],
    1 => [
        'name' => 'Beauty & Health',
        'title' => 'Lowest Deals on Beauty & Health'
    ],
    8 => [
        'name' => 'TV, Audio/Video & Movies',
        'title' => 'Television & Media'
    ],
    7 => [
        'name' => 'Mobiles & Tablets',
        'title' => 'Most Liked Deals on Mobile and Tablets'
    ],
    9 => [
        'name' => 'Computers, Laptops & Gaming',
        'title' => 'Great Offers on Computers, Laptops & Gaming'
    ]
];

foreach ($displayCategories as $categoryId => $categoryInfo):
    // Get products for this category
    $categoryProducts = getProductsByCategory($connect, $categoryId, 12);
    
    if (empty($categoryProducts)) {
        continue; // Skip if no products
    }
    
    // Generate unique slider ID
    $sliderId = 'categoryProducts' . $categoryId;
?>

<section class="category-products-section">
    <div class="uk-container">
        <div class="category-products-header">
            <h2 class="category-products-title">
                <i class="ti ti-shopping-bag"></i>
                <?php echo htmlspecialchars($categoryInfo['title']); ?>
            </h2>
            <a href="<?php echo SITE_URL; ?>/category/<?php echo getCategorySlug($connect, $categoryId); ?>" class="view-all-link">
                View All <i class="ti ti-chevron-right"></i>
            </a>
        </div>

        <div class="category-products-swiper">
            <div class="swiper <?php echo $sliderId; ?>">
                <div class="swiper-wrapper">
                    <?php foreach ($categoryProducts as $product): ?>
                    <div class="swiper-slide">
                        <div class="compact-product-card">
                            <!-- Discount Badge -->
                            <?php if ($product['product_discount_percentage']): ?>
                            <div class="compact-product-badge">
                                <?php echo $product['product_discount_percentage']; ?>% OFF
                            </div>
                            <?php endif; ?>

                            <!-- Product Image -->
                            <div class="compact-product-image-wrapper">
                                <img src="<?php echo getImageUrl($product['product_image_cdn_url'], $product['product_use_cdn'], $product['product_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($product['product_title']); ?>"
                                     class="compact-product-image"
                                     loading="lazy">
                            </div>

                            <!-- Product Content -->
                            <div class="compact-product-content">
                                <?php if ($product['store_title']): ?>
                                <div class="compact-product-brand"><?php echo htmlspecialchars($product['store_title']); ?></div>
                                <?php endif; ?>

                                <h3 class="compact-product-title"><?php echo htmlspecialchars($product['product_title']); ?></h3>

                                <div class="compact-product-pricing">
                                    <div class="compact-product-price-row">
                                        <?php if ($product['product_sale_price']): ?>
                                        <span class="compact-product-sale-price">₹<?php echo number_format($product['product_sale_price'], 0); ?></span>
                                        <?php endif; ?>
                                        
                                        <?php if ($product['product_original_price'] && $product['product_original_price'] > $product['product_sale_price']): ?>
                                        <span class="compact-product-original-price">₹<?php echo number_format($product['product_original_price'], 0); ?></span>
                                        <?php endif; ?>
                                        
                                        <?php if ($product['product_discount_percentage']): ?>
                                        <span class="compact-product-discount">(<?php echo $product['product_discount_percentage']; ?>% off)</span>
                                        <?php endif; ?>
                                    </div>

                                    <?php if ($product['product_cashback']): ?>
                                    <div class="compact-product-cashback">
                                        <i class="ti ti-coin"></i> <?php echo htmlspecialchars($product['product_cashback']); ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Buy Button -->
                            <div class="compact-product-footer">
                                <a href="<?php echo htmlspecialchars($product['product_affiliate_link']); ?>" 
                                   target="_blank" 
                                   rel="nofollow noopener"
                                   class="compact-product-buy-btn">
                                    <i class="ti ti-tag"></i>
                                    Get Deal
                                </a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- Navigation -->
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </div>
</section>

<div class="category-section-divider"></div>

<?php endforeach; ?>

<script>
// Initialize category product sliders
document.addEventListener('DOMContentLoaded', function() {
    <?php foreach ($displayCategories as $categoryId => $categoryInfo): ?>
    <?php 
    $categoryProducts = getProductsByCategory($connect, $categoryId, 12);
    if (!empty($categoryProducts)): 
    ?>
    new Swiper('.categoryProducts<?php echo $categoryId; ?>', {
        slidesPerView: 2,
        spaceBetween: 15,
        loop: false,
        navigation: {
            nextEl: '.categoryProducts<?php echo $categoryId; ?> .swiper-button-next',
            prevEl: '.categoryProducts<?php echo $categoryId; ?> .swiper-button-prev',
        },
        pagination: {
            el: '.categoryProducts<?php echo $categoryId; ?> .swiper-pagination',
            clickable: true,
        },
        breakpoints: {
            480: {
                slidesPerView: 2,
                spaceBetween: 15,
            },
            640: {
                slidesPerView: 3,
                spaceBetween: 15,
            },
            768: {
                slidesPerView: 4,
                spaceBetween: 20,
            },
            1024: {
                slidesPerView: 5,
                spaceBetween: 20,
            },
            1280: {
                slidesPerView: 6,
                spaceBetween: 20,
            }
        }
    });
    <?php endif; ?>
    <?php endforeach; ?>
});
</script>
