// Firebase Authentication Handler
let firebaseApp = null;
let auth = null;
let recaptchaVerifier = null;
let confirmationResult = null;

// Initialize Firebase
function initFirebase(config) {
    if (!firebase || !config.apiKey) {
        return false;
    }
    
    try {
        firebaseApp = firebase.initializeApp(config);
        auth = firebase.auth();
        return true;
    } catch (error) {
        return false;
    }
}

// Setup reCAPTCHA
function setupRecaptcha(elementId) {
    if (!auth) return;
    
    recaptchaVerifier = new firebase.auth.RecaptchaVerifier(elementId, {
        'size': 'invisible',
        'callback': function(response) {
            // reCAPTCHA solved
        }
    });
}

// Send OTP to mobile number
function sendOTP(phoneNumber, countryCode = '+91') {
    return new Promise((resolve, reject) => {
        if (!auth) {
            reject('Firebase not initialized');
            return;
        }
        
        const fullNumber = countryCode + phoneNumber;
        
        if (!recaptchaVerifier) {
            setupRecaptcha('recaptcha-container');
        }
        
        auth.signInWithPhoneNumber(fullNumber, recaptchaVerifier)
            .then(function(result) {
                confirmationResult = result;
                resolve(result);
            })
            .catch(function(error) {
                reject(error.message);
            });
    });
}

// Verify OTP
function verifyOTP(code) {
    return new Promise((resolve, reject) => {
        if (!confirmationResult) {
            reject('No OTP sent yet');
            return;
        }
        
        confirmationResult.confirm(code)
            .then(function(result) {
                const user = result.user;
                resolve(user);
            })
            .catch(function(error) {
                reject(error.message);
            });
    });
}

// Google Sign-In
function signInWithGoogle() {
    return new Promise((resolve, reject) => {
        if (!auth) {
            reject('Firebase not initialized');
            return;
        }
        
        const provider = new firebase.auth.GoogleAuthProvider();
        
        auth.signInWithPopup(provider)
            .then(function(result) {
                const user = result.user;
                resolve(user);
            })
            .catch(function(error) {
                reject(error.message);
            });
    });
}

// Facebook Sign-In
function signInWithFacebook() {
    return new Promise((resolve, reject) => {
        if (!auth) {
            reject('Firebase not initialized');
            return;
        }
        
        const provider = new firebase.auth.FacebookAuthProvider();
        
        auth.signInWithPopup(provider)
            .then(function(result) {
                const user = result.user;
                resolve(user);
            })
            .catch(function(error) {
                reject(error.message);
            });
    });
}

// Sign out
function signOutFirebase() {
    if (auth) {
        return auth.signOut();
    }
}
