<?php require '../views/header.view.php'; ?>
<link rel="stylesheet" href="../assets/css/import-export.css">

<div class="import-export-container">
    <div class="uk-container uk-container-large">
        
        <div class="import-export-header">
            <h2><i class="ti ti-file-import"></i> Import / Export</h2>
        </div>
        
        <?php if (isset($_SESSION['import_success'])): ?>
        <div class="uk-alert-success" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p><?php echo $_SESSION['import_success']; unset($_SESSION['import_success']); ?></p>
        </div>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['import_errors'])): ?>
        <div class="uk-alert-warning" uk-alert>
            <a class="uk-alert-close" uk-close></a>
            <p><?php echo $_SESSION['import_errors']; unset($_SESSION['import_errors']); ?></p>
        </div>
        <?php endif; ?>
        
        <div class="uk-grid-medium uk-child-width-1-2@m" uk-grid>
            
            <!-- Import Section -->
            <div>
                <div class="import-export-card">
                    <h3><i class="ti ti-upload"></i> Import Coupons</h3>
                    <p class="uk-text-meta">Upload a CSV file to import coupons. Stores will be auto-created if they don't exist.</p>
                    
                    <form method="post" action="?action=import_coupons" enctype="multipart/form-data" class="uk-margin-top">
                        
                        <div class="uk-margin">
                            <label class="uk-form-label">CSV File</label>
                            <div uk-form-custom="target: true">
                                <input type="file" name="csv_file" accept=".csv" required>
                                <input class="uk-input" type="text" placeholder="Select CSV file..." disabled>
                            </div>
                            <p class="uk-text-small uk-text-muted uk-margin-small-top">
                                <strong>CSV Format:</strong> Title, Merchant, Description, Coupon Code, URL, Start Date, End Date
                            </p>
                        </div>
                        
                        <div class="uk-margin">
                            <button type="submit" class="uk-button uk-button-primary">
                                <i class="ti ti-upload"></i> Import Coupons
                            </button>
                        </div>
                        
                        <div class="info-box">
                            <h4>Import Notes:</h4>
                            <ul class="uk-list uk-list-bullet">
                                <li>Stores will be automatically created if they don't exist</li>
                                <li>Categories and images will be skipped (set to default)</li>
                                <li>Date format: DD-MM-YYYY (e.g., 20-05-2025)</li>
                                <li>Duplicate coupons will be created (no duplicate check)</li>
                            </ul>
                        </div>
                        
                    </form>
                </div>
            </div>
            
            <!-- Store Image Upload Section -->
            <div>
                <div class="import-export-card">
                    <h3><i class="ti ti-photo"></i> Upload Store Image</h3>
                    <p class="uk-text-meta">Upload store logo/image via URL with live preview.</p>
                    
                    <form method="post" action="?action=upload_store_image" class="uk-margin-top">
                        
                        <div class="uk-margin">
                            <label class="uk-form-label">Select Store</label>
                            <select name="store_id" class="uk-select" required>
                                <option value="">-- Select Store --</option>
                                <?php
                                $stores = $conn->query("SELECT store_id, store_title FROM stores ORDER BY store_title ASC");
                                while($store = $stores->fetch(PDO::FETCH_ASSOC)) {
                                    echo '<option value="'.$store['store_id'].'">'.$store['store_title'].'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        
                        <div class="uk-margin">
                            <label class="uk-form-label">Image URL</label>
                            <input type="url" name="image_url" id="imageUrl" class="uk-input" placeholder="https://example.com/logo.png" required>
                            <p class="uk-text-small uk-text-muted uk-margin-small-top">
                                Enter the direct URL to the store logo/image
                            </p>
                        </div>
                        
                        <div class="uk-margin">
                            <label class="uk-form-label">Preview</label>
                            <div id="imagePreview" class="image-preview-box">
                                <p class="uk-text-muted">Enter image URL to see preview</p>
                            </div>
                        </div>
                        
                        <div class="uk-margin">
                            <button type="submit" class="uk-button uk-button-primary">
                                <i class="ti ti-check"></i> Upload Image
                            </button>
                        </div>
                        
                        <div class="info-box">
                            <h4>Image Requirements:</h4>
                            <ul class="uk-list uk-list-bullet">
                                <li>Use direct image URLs (ending in .jpg, .png, .gif, etc.)</li>
                                <li>Recommended size: 200x200px or larger</li>
                                <li>Supports: JPG, PNG, GIF, WebP formats</li>
                                <li>Image will be downloaded and saved locally</li>
                            </ul>
                        </div>
                        
                    </form>
                </div>
            </div>
            
        </div>
        
        <div class="uk-grid-medium uk-child-width-1-1" uk-grid>
                    
                    <form method="post" action="?action=import_coupons" enctype="multipart/form-data" class="uk-margin-top">
                        
                        <div class="uk-margin">
                            <label class="uk-form-label">CSV File</label>
                            <div uk-form-custom="target: true">
                                <input type="file" name="csv_file" accept=".csv" required>
                                <input class="uk-input" type="text" placeholder="Select CSV file..." disabled>
                            </div>
                            <p class="uk-text-small uk-text-muted uk-margin-small-top">
                                <strong>CSV Format:</strong> Title, Merchant, Description, Coupon Code, URL, Start Date, End Date
                            </p>
                        </div>
                        
                        <div class="uk-margin">
                            <button type="submit" class="uk-button uk-button-primary">
                                <i class="ti ti-upload"></i> Import Coupons
                            </button>
                        </div>
                        
                        <div class="info-box">
                            <h4>Import Notes:</h4>
                            <ul class="uk-list uk-list-bullet">
                                <li>Stores will be automatically created if they don't exist</li>
                                <li>Categories and images will be skipped (set to default)</li>
                                <li>Date format: DD-MM-YYYY (e.g., 20-05-2025)</li>
                                <li>Duplicate coupons will be created (no duplicate check)</li>
                            </ul>
                        </div>
                        
                    </form>
                </div>
            </div>
            <!-- Export Section -->
            <div>
                <div class="import-export-card">
                    <h3><i class="ti ti-download"></i> Export Data</h3>
                    <p class="uk-text-meta">Download your coupons and stores as CSV files.</p>
                    
                    <div class="stats-box">
                        <h4>Statistics</h4>
                        <ul class="uk-list">
                            <li><strong>Total Coupons:</strong> <?php echo $total_coupons; ?></li>
                            <li><strong>Total Stores:</strong> <?php echo $total_stores; ?></li>
                        </ul>
                    </div>
                    
                    <div class="uk-margin-top">
                        <a href="?action=export_coupons" class="uk-button uk-button-default uk-margin-small-right">
                            <i class="ti ti-download"></i> Export Coupons
                        </a>
                        <a href="?action=export_stores" class="uk-button uk-button-default">
                            <i class="ti ti-download"></i> Export Stores
                        </a>
                    </div>
                    
                    <div class="info-box">
                        <h4>Export Format:</h4>
                        <p><strong>Coupons CSV:</strong> Title, Merchant, Description, Coupon Code, URL, Start Date, End Date</p>
                        <p><strong>Stores CSV:</strong> Store Name, Description, Slug, Featured, Status</p>
                    </div>
                </div>
            </div>
            
        </div>
        
        <div class="uk-grid-medium uk-child-width-1-1" uk-grid>
            
            <!-- Export Section -->
        <div class="template-box">
            <h3><i class="ti ti-file-text"></i> Sample CSV Template</h3>
            <p>Use this format for your CSV file:</p>
            <pre>Title,Merchant,Description,Coupon Code,URL,Start Date,End Date
"Get Flat Rs. 1000 Discount",Acwo,"Save Rs. 1000 on your order",ULTRA1000,https://example.com/,20-05-2025,31-12-2025
"50% Off on Party Wear",Mufti,"Get 50% discount on party wear",,https://example.com/,20-05-2025,31-12-2025</pre>
        </div>
        
    </div>
</div>

<script>
// Image Preview
document.getElementById('imageUrl').addEventListener('input', function() {
    const url = this.value;
    const preview = document.getElementById('imagePreview');
    
    if (url && isValidImageUrl(url)) {
        preview.innerHTML = '<img src="' + url + '" alt="Preview" style="max-width: 200px; max-height: 200px; border-radius: 8px;">';
    } else {
        preview.innerHTML = '<p class="uk-text-muted">Enter valid image URL to see preview</p>';
    }
});

function isValidImageUrl(url) {
    return url.match(/\.(jpeg|jpg|gif|png|webp|svg)$/i) != null || url.includes('image');
}
</script>

<?php require '../views/footer.view.php'; ?>
